<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Database handler for WHMCS
 * @desc		This works with the database from WHMCS for the Dunamis Framework
 * @package		Dunamis
 * @subpackage	WHMCS
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class WhmcsDunDatabase extends DunDatabase
{
	/**
	 * Constructor Method
	 * @access		public
	 * @version		1.4.4
	 * @version		1.0.8		- March 2013: Database construction moved to parent
	 * @param		array		- $options: contains an array of arguments
	 * 
	 * @since		1.0.0
	 */
	public function __construct( $options = array() )
	{
		// ---- BEGIN INTOUCH-5 / DUN-4
		//		Quote duplication is failing with In Touch activate
		global $whmcsmysql;
		
		if ( is_resource( $whmcsmysql ) ) {
			$this->_resource	= & $whmcsmysql;
			return;
		}
		// ---- END INTOUCH-5 / DUN-4
		
		// Include the WHMCS configuration file
		include( DUN_ENV_PATH . 'configuration.php' );
		
		// Setup the options array
		$options['hostname']	=	$db_host;
		$options['username']	=	$db_username;
		$options['password']	=	$db_password;
		$options['database']	=	$db_name;
		
		// Construct the object
		parent :: __construct( $options );
	}
	
	
	/**
	 * Given a filename and extension and type parse and execute commands
	 * @access		public
	 * @version		1.4.4
	 * @param		string		- $filename: the relative path and filename
	 * @param		string		- $extension: the extension name
	 * 
	 * @return		boolean
	 * @since		1.0.0
	 */
	public function handleFile( $filename, $extension = null )
	{
		$path	= WhmcsDunModule :: locateModule( $extension ) . $filename;
		
		if (! file_exists( $path ) ) return false;
		
		$commands = $this->parseFile( $path );
		
		foreach ( $commands as $sql ) {
			$this->setQuery( $sql );
			$this->query();
		}
		
		return true;
	}
}