<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Form handler for WHMCS
 * @desc		This creates and manages HTML forms from WHMCS for the Dunamis Framework
 * @package		Dunamis
 * @subpackage	WHMCS
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class WhmcsDunForm extends DunForm
{
	/**
	 * Constructor method
	 * @access		public
	 * @version		1.4.4
	 * @param		array		- $options: any options to set
	 * 
	 * @since		1.0.0
	 */
	public function __construct()
	{
		parent :: __construct();
	}
	
	
	/**
	 * Method to load a form
	 * @access		public
	 * @version		1.4.4
	 * @param		string		- $extension: the name of the extension requesting
	 * @param		string		- $file: the filename to get
	 * @param		integer		- $type: the defined type
	 * 
	 * @since		1.0.0
	 */
	public function loadFormold( $extension = null, $file = null, $type = 0 )
	{
		if ( $extension == null || $file == null ) return;
		
		static $requested	= array();
		if ( isset( $requested[$extension][$file] ) ) return $requested[$extension][$file];
		if (! isset( $requested[$extension] ) ) $requested[$extension] = array();
		
		$instance	= new self( array() );
		$form		= $instance->_readFile( $extension, $file, $type );
		
		$instance->parseForm( $form, $extension, $type, $file );
		
		$requested[$extension][$file] = $instance;
// 		$form	= $this->_readFile( $extension, $file, $type );
// 		$this->parseForm( $form, $extension, $type, $file );
		
		return $requested[$extension][$file];
	}
	
	
	/**
	 * Method to read a file and provide a repository in case we need to call it many times
	 * @access		private
	 * @version		1.4.4
	 * @param		string		- $extension: the name of the extension requesting
	 * @param		string		- $file: the filename to get
	 * @param		integer		- $type: the defined type
	 * 
	 * @return		array
	 * @since		1.0.0
	 */
	private function _readFile( $extension, $file, $type )
	{
		static $requested	= array();
		if ( isset( $requested[$extension][$file] ) ) return $requested[$extension][$file];
		if (! isset( $requested[$extension] ) ) $requested[$extension] = array();
		
		$path		= WhmcsGoFDefines :: getPaths( $type ) . $extension . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR;
		$filename	= $path . $file . '.php';
	
		if (! file_exists( $filename ) ) {
			$form = array();
		}
		else {
			include( $filename );
		}
	
		$requested[$extension][$file] = $form;
		return $requested[$extension][$file];
	}
}