<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'settings', 'blocked')}</li>
</ul>

<div class="panel panel-primary" id='blocked-settings'>
    <div class="panel-heading">
        <h3 class="panel-title">{$MGLANG->T('configure_blocked_strings')}</h3>
    </div>
    <div class="panel-body">
        <form>
            <div class="form-group">
                <label>{$MGLANG->T('dns_blocked_strings')}</label>
                <textarea name='dns_blocked' rows='5' class="form-control">{$dnsBlockedStrings}</textarea>
            </div>

            <div class="form-group">
                <label>{$MGLANG->T('rdns_blocked_strings')}</label>
                <div class='row'>
                    <div class='col-lg-12 checkbox'>
                        <label style='padding-left: 0'>
                            <input type='checkbox' id="useDNSasRDNS" name='use_rdns_blocked_same_as_for_dns' {if $useRdnsBlockedSameAsForDns eq 'on'}checked{/if} class='use-rdns-blocked-same-as-for-dns'/>
                            {$MGLANG->T('use_rdns_blocked_same_as_for_dns')}
                        </label>
                    </div>
                </div>
                <textarea {if $useRdnsBlockedSameAsForDns eq 'on'}readonly{/if} name='rdns_blocked' rows='5' class="form-control rdns-blocked-textarea">{$rdnsBlockedStrings}</textarea>
            </div>

            <div class="form-group">
                <label>{$MGLANG->T('blocked_strings_excluded_clients')}</label>
                <select name='blocked_strings_excluded_clients[]' multiple class='select2'>
                    {foreach from=$clients item=client}
                        {$clientId = $client.id}
                        <option value='{$clientId}' {if $excludedClients.$clientId}selected{/if}>{$client.firstname} {$client.lastname}</option>
                    {/foreach}
                </select>
            </div>

            <a class="btn btn-primary btn-inverse" data-act="saveBlocked" data-formid="blocked-settings">{$MGLANG->T('save_changes')}</a>
        </form>
    </div>
</div>

<script data-cfasync="false" type="text/javascript">
        $(document).on('change', '#useDNSasRDNS', function () {
            if (this.checked == true) {
                $('textarea[name="rdns_blocked"]').attr('readonly', 'readonly');
            } else {
                $('textarea[name="rdns_blocked"]').removeAttr('readonly');
            }

        })
</script>