<div class="modal fade modal-lg" id="edit-set-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                <h4 class="modal-title">{if $set.edit}{$MGLANG->T('set_edit')}{else}{$MGLANG->T('add_set')}{/if}</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    {if $set.edit}<input type="hidden" name="id" value="{$set.id}" />{/if}
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">{$MGLANG->T('name')}</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="name" value="{$set.name}" required pattern="{$patterns.no_white_chars_at_beginning}">
                        </div>
                    </div>
                    <div class="row set-records">
                        <div class="col-md-12">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach from=$set.records item="record"}
                                        <tr>
                                            <td><input type="text" class="form-control" name="record[{$counter}][name]" value="{$record->name}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','name')}" placeholder="{$MGLANG->absoluteT('addonAA','zones','name')}"/></td>
                                            <td><input type="text" class="form-control" disabled="" name="record[{$counter}][type]" value="{$record->type}" title="{$MGLANG->absoluteT('addonAA','zones','record_type_info',$record->type)}"/><input type="hidden" name="record[{$counter}][type]" value="{$record->type}"/></td>
                                            <td><input type="text" class="form-control" name="record[{$counter}][ttl]" value="{$record->ttl}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','ttl')}" placeholder="{$MGLANG->absoluteT('addonAA','zones','ttl')}"/></td>
                                            <td>
                                                {foreach from=$record->rdata key="field" item="value"}
                                                    <input type="text" class="form-control table-input" name="record[{$counter}][field][{$field}]" value="{$value}" placeholder="{$field}" title="{$MGLANG->absoluteT('addonAA','zones','record_field_info',$record->type,$field)}"/>
                                                {/foreach}
                                            </td>
                                            <td>
                                                <input name="record[{$counter}][id]" type="hidden" value="{$record->id}" />
                                                <a class="btn btn-danger  btn-inverse btn-icon-only" onclick="$(this).parents('div.set-records').first().append('<input type=\'hidden\' name=\'remove_record[]\' value=\'{$record->id}\' />'); removeRecord($(this));" title="{$MGLANG->T('remove')}"><span class="glyphicon glyphicon-remove"></span></a>
                                            </td>
                                        </tr>
                                        {assign var="counter" value=$counter+1}
                                    {/foreach}
                                    <tr class="nobody-is-here" {if count($set.records)}style="display: none;"{/if}>
                                        <td colspan="5" class="text-center">{$MGLANG->T('there_is_no_record_within_this_set')}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4"></div>
                        <div class="col-md-4"></div>
                        <div class="col-md-4">
                            <div class="row add-me-right-here">
                                <div class="col-md-9 col-xs-6">
                                    <input type="hidden" name="records_counter" value="{$set.count + 1}" />
                                    <select class="select2" name="new_record_type">
                                    {foreach from=$available_record_types item="record"}
                                        <option value="{$record}">{$record}</option>
                                    {/foreach}
                                    </select>
                                </div>
                                <div class="col-md-3 col-xs-3">
                                    <a class="btn btn-success  btn-inverse" data-act="addNewRecord" data-do-not-close-the-modal="" data-no-validate="1" title="{$MGLANG->T('add_new_record')}">
                                        <span class="glyphicon glyphicon-plus"></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('close')}</button>
                {if $set.edit}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="setSave">{$MGLANG->T('save_changes')}</button>
                {else}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="setSave">{$MGLANG->T('add')}</button>
                {/if}
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->     