<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'settings', 'servers')}</li>
</ul>

<table class="table table-striped" id="serverlist">
    <thead>
        <tr>
            <th>{$MGLANG->T('table','name')}</th>
            <th>{$MGLANG->T('table','type')}</th>
            <th>{$MGLANG->T('table','default_ip')}</th>
            <th>{$MGLANG->T('table','rdns')}</th>
            <th>{$MGLANG->T('table','multiple_ptr')}</th>
            <th>{$MGLANG->T('table','status')}</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>
    
<div class="well">
    <a class="btn btn-success btn-inverse" data-act="addServer">{$MGLANG->T('add_server')}</a>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#serverlist').DataTable().ajax.reload();
            });
            
            jQuery('#serverlist').dataTable({
                  drawCallback:replaceEmptyRowDataTable,
                  serverSide: true,
                //  searching: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          data.start = 0;
                      }
                      last = data.length;
                  
                      var filters = $('#table-filters :input').serializeArray();
                      JSONParser.request(
                          'refreshServersTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                          }
                      );
                  },
                  columns: [
                      {name: 'name'}
                      ,{name: 'module'}
                      ,{name: 'default_ip', orderable: false}
                      ,{name: 'allow_rdns', orderable: false}
                      ,{name: 'multiple_ptr', orderable: false}
                      ,{name: 'status', orderable: false}
                      ,{ orderable: false, targets: 0}
                  ],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],
                  iDisplayLength: 10,
                  //sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                  "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   }
            });
            
        });
    </script>
{/literal}

{literal}
    <script data-cfasync="false" type="text/javascript">
        function getModuleConfigurationCallback(data, $obj) {
            var $modal = $obj.parents('.modal').first();
            $modal.find('.module-configuration').html(data.html);
            $modal.find('.nav-tabs [href="#configuration-tab"]').show().tab('show');
            $modal.find('.nav-tabs [href="#nameservers-tab"]').show();
        }
        
        function getAdditionalConfigurationCallback(data,$obj)
        {
            var $modal = $obj.parents('.modal').first();
            $modal.find('.additional-configuration').html(data.html);
        }
        
        function refreshServerTable() {
            jQuery('#serverlist').DataTable().ajax.reload();
        }
        
        function turnOffServerCallback(data, obj) {
            refreshServerTable();
        }
        
        function turnOnServerCallback(data, obj) {
            refreshServerTable();
        }
        
        function deleteServerCallback(data, obj) {
            refreshServerTable();
        }
        
        function serverSaveCallback(data, obj) {
            refreshServerTable();
        }
    </script>
{/literal}