<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'backupsList')}</li>
</ul>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="panel-title">{$MGLANG->T('backupsTasks')}</h3>
    </div>
    <div class="panel-body">
        <table class="table table-hover table-striped" id="backupsTasksList">
            <thead>
                <tr>
                    <th>{$MGLANG->T('taskDescription')}</th>
                    <th>{$MGLANG->T('zones_procesed_total')}</th>
                    <th>{$MGLANG->T('progress')}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$backupsTasks item="backupTask"}
                    <tr>
                        <td>{$backupTask.parsedDesc.0}<b>{$backupTask.parsedDesc.1}</b>{if $backupTask.parsedDesc.2}{$backupTask.parsedDesc.2}<b>{$backupTask.parsedDesc.3}</b>{/if}</td>
                        <td>{$backupTask.zones_imported}/{$backupTask.zones_total}</td>
                        <td>
                            {if $backupTask.error neq false}
                                {$backupTask.error}
                            {elseif $backupTask.progress < 0}
                                {$MGLANG->T('fetching_list')}
                            {else}
                            <div class="progress" style="margin-bottom: 0px;">
                                <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="{$backupTask.progress}" aria-valuemin="0" aria-valuemax="100" style="width: {$backupTask.progress}%;">{$backupTask.progress}%</div>
                            </div>
                            {/if}
                        </td>
                        <td>
                        {if $backupTask.progress >= 0 && $backupTask.error eq false}
                            <a class="btn btn-primary btn-inverse btn-icon-only" data-act="{if $backupTask.type === 'importToFIle'}showListImportToFile{else}showListExport{/if}" data-query="id={$backupTask.id}" title="{$MGLANG->T('show_list')}"><i class="fa fa-edit"></i></a>
                        {/if}
                            <a class="btn btn-primary btn-inverse btn-icon-only" data-act="{if $backupTask.type === 'importToFIle'}backupScheduleImport{else}backupScheduleExport{/if}" data-query="id={$backupTask.id}" data-confirm-body="{if $backupTask.type === 'importToFIle'}{$MGLANG->T('schedule_import_confirmation')}{else}{$MGLANG->T('scheduleExportConfirmation')}{/if}" title="{$MGLANG->T('scheduleTask')}"><i class="fa fa-play"></i></a>
                            <a class="btn btn-danger btn-inverse btn-icon-only" data-act="backupRemoveTask" data-confirm-body="{if $backupTask.type === 'importToFIle'}{$MGLANG->T('remove_import_confirmation')}{else}{$MGLANG->T('removeExportConfirmation')}{/if}" data-query="id={$backupTask.id}" title="{$MGLANG->T('cancel')}"><i class="fa fa-remove"></i></a>
                        </td>
                    </tr>
                {foreachelse}
                    <tr><td colspan="4" align="center">{$MGLANG->T('there_are_no_backup_tasks')}</td></tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="panel-title">{$MGLANG->T('backupsList')}</h3>
    </div>
    <div class="panel-body">
        <table class="table table-hover table-striped" id="backupsList">
            <thead>
                <tr>
                    <th>{$MGLANG->T('fileName')}</th>
                    <th>{$MGLANG->T('exportType')}</th>
                    <th class="action-cell"></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
        <div class="well well-sm">
            <a class="btn btn-success btn-inverse" data-act="addBackupFile">{$MGLANG->T('uploadFile')}</a>
            <a class="btn btn-info btn-inverse" data-act="addExportToFIle">{$MGLANG->T('addExportToFile')}</a>
        </div>             
    </div>
</div>
        
{literal}
    <script data-cfasync="false" type="text/javascript">



        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#backupsList').DataTable().ajax.reload();
            });
            
            jQuery('#backupsList').dataTable({
                  drawCallback: replaceEmptyRowDataTable,
                  serverSide: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          last = data.length;
                          data.start = 0;
                          jQuery('#backupsList').DataTable().page(0);
                      }
                      last = data.length;
                      
                      var filters = $('#table-filters :input').serializeArray();
                      JSONParser.request(
                          'refreshBackupsTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                              addCustomPagination('backupsList', 0);
                          }
                      );

                  },
                  columns: [
                      {name: 'name'},
                      {orderable: false, name: 'type'},
                      {orderable: false, targets: 0}
                  ],
                  // order: [[0, "desc"]],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],
                  iDisplayLength: 10,
                    "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}"
                    }
            });
        });
    </script>
{/literal}        
