<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'tasks')}</li>
</ul>

<div id="table-filters" class="hide">
    <select name="filter[serverid]">
        <option value=""></option>
    </select>
</div>

<table class="table table-hover table-striped" id="tastklist">
    <thead>
        <tr>
            <th>{$MGLANG->T('table','name')}</th>
            <th style="width:5%;">{$MGLANG->T('table','status')}</th>
            <th style="width:10%;">{$MGLANG->T('table','Progress')}</th>
            <th>{$MGLANG->T('table','lastrun')}</th>
            {*<th>{$MGLANG->T('table','nextrun')}</th>*}
            <th>{$MGLANG->T('table','created_at')}</th>
            <th class="action-cell"></th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>        
        
{literal}
    <script data-cfasync="false" type="text/javascript">
        function refreshTable() {
            jQuery('#tastklist ').DataTable().ajax.reload();
        }
        
        function removeTaskCallback(data, $obj) { refreshTable();}
        function taskRunNowCallback(data, $obj) { refreshTable();}
        
        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#tastklist').DataTable().ajax.reload();
            });
            
            jQuery('#tastklist').dataTable({
                  drawCallback: replaceEmptyRowDataTable,
                  serverSide: true,
                //  searching: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          data.start = 0;
                      }
                      last = data.length;
                  
                      var filters = $('#table-filters :input').serializeArray();
                      JSONParser.request(
                          'refreshTasksTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                          }
                      );
                  },
                  columns: [
                      {name: 'name'}                   
                      ,{name: 'status'}
                      ,{name: 'progress'}
                      ,{name: 'lastrun'}
                     // ,{name: 'nextrun'}
                      ,{name: 'date'}
                      ,{ orderable: false, targets: 0}
                  ],
                  order: [[4, "desc"]],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],
                  iDisplayLength: 10,
                  //sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                  "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   }
            });
            
        });
    </script>
{/literal}
