<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'zones', 'label')}</li>
</ul>

<div id="table-filters" class="hide">
    <select name="filter[serverid]">
        <option value="">{$MGLANG->T('none')}</option>
        {foreach from=$servers item="server"}
            <option value="{$server->id}">{$server->name}</option>
        {/foreach}
    </select>
</div>

<table class="table table-hover table-striped" id="zonelist">
    <thead>
        <tr>
            <th style="width:0px"><div class="checkbox" id="select_all"><input type="checkbox" class="select_all"/><input type="hidden" name="id"/></div></th>
            <th>{$MGLANG->T('table','name')}</th>
            <th>{$MGLANG->T('table','client')}</th>
            <th>{$MGLANG->T('table','type')}</th>
            <th>{$MGLANG->T('table','server')}</th>
            <th>{$MGLANG->T('table','status')}</th>
            <th class="action-cell"></th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>   
            
<div class="well">
   <button style="margin-left: 10px;" class="btn btn-success btn-inverse" type="button" data-act="addZone">{$MGLANG->T('add_zone')}</button>
   <button style="margin-left: 10px;" class="btn btn-primary btn-inverse" type="button" data-formid="zonelist" data-dt="1" data-act="setRecords">{$MGLANG->T('set_dns_record_set')}</button>
    <span id="massRemoveButton" class="hidden">
        <button style="margin-left: 10px;" class="btn btn-danger btn-inverse" type="button" data-formid="zonelist" data-dt="1" data-act="massRemoveZones">{$MGLANG->T('delete_selected')}</button>
        <button style="margin-left: 10px;" class="btn btn-danger btn-inverse" type="button" data-formid="zonelist" data-dt="1" data-act="massRemoveZonesFromWHMCS">{$MGLANG->T('remove_from_whmcs_selected')}</button>
   </span>
</div>
        
{literal}
    <script data-cfasync="false" type="text/javascript">   
        
            function toggleActionButtons(status){
                if(status === true){
                    $('#massRemoveButton').removeClass('hidden');
                }else{
                    $('#massRemoveButton').addClass('hidden');
                }
            }
            
            jQuery('#select_all').change(function(){
               jQuery('input[type="checkbox"]').prop('checked',$("#select_all :input")[0].checked).iCheck('update');
               toggleActionButtons($("#select_all :input")[0].checked);
            });
            
            jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#zonelist').DataTable().ajax.reload();
            });
            
            function fixCheckBoxes()
            {

                $(".mg-wrapper .checkbox input[type='checkbox']").iCheck({
                    checkboxClass: 'checkbox-styled',
                    radioClass: 'radio-styled',
                    increaseArea: '20%'
                });
                
                $('input[name*="zone[checked]"]').change(function(){
                    var select_all = true;
                    var checkboxes = $('input[name*="zone[checked]"]');
                    var checkedNumers = 0;
                    checkboxes.each(function(key,val){
                        if(val.checked == false)
                        {
                            select_all = false;
                        }else{
                            checkedNumers++
                        }
                    });       
                    if(!select_all)
                    {
                       jQuery('input[class="select_all"]').prop('checked',false).iCheck('update');
                    }
                    else
                    {
                        jQuery('input[class="select_all"]').prop('checked',true).iCheck('update');
                    }
                    
                    if(checkedNumers > 0){
                        toggleActionButtons(true);
                    }
                    else{
                       toggleActionButtons(false); 
                    }
                });
                replaceEmptyRowDataTable();
            }

            $('#MGModal').on('hidden.bs.modal', function(){
                fixCheckBoxes();
            });


            jQuery('#zonelist').dataTable({
                  drawCallback:fixCheckBoxes,
                  serverSide: true,
                  info: true,
                //  searching: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          last = data.length;
                          data.start = 0;
                          jQuery('#zonelist').DataTable().page(0);
                      }
                      last = data.length;
                      
                      var filters = $('#table-filters :input').serializeArray();
                      JSONParser.request(

                          'refreshZonesTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                          }
                      );
                  },

                  columns: [
                      {orderable:false, name: 'check'}
                      ,{name: 'name'}
                      ,{name: 'client'}
                      ,{orderable: false, name: 'type'}
                      ,{name: 'server_name'}
                      ,{name: 'status'}
                      ,{ orderable: false, targets: 0}
                  ],
                  order: [[4, "desc"]],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],

                  iDisplayLength: 10,
                  //sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                   "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   },



            });
        });
    </script>
{/literal}
    
{literal}
    <script data-cfasync="false" type="text/javascript">
        function refreshTable() {
            jQuery('#zonelist').DataTable().ajax.reload();            
            //jQuery('#zonelist').DataTable().draw();
        }
        function showinfo() {

            if($('.dataTables_empty').length > 0)
            {
                jQuery('#zonelist').DataTable().info = false;
            }
            jQuery('#zonelist').DataTable().info = true;
        }
        
        function synchronizeZoneCallback(data, $obj) {refreshTable();}
        function createZoneCallback(data, $obj) {refreshTable();}
        function removeZoneFromWHMCSCallback(data, $obj) {refreshTable();}
        function removeZoneCallback(data, $obj) {refreshTable();}
        function switchRelatedItemSaveCallback(data, $obj) {refreshTable();}
        
        function addNewRecordCallback(data, $obj) {
            if(!data.new_record) return false;
            //$obj.parents('form').first().find('.zone-records table tbody').append(data.new_record);
           // $obj.parent().children('[name=records_counter]').val(parseInt($obj.parent().children('[name=records_counter]').val()) + 1);
           $obj.parents('form').first().find('.new-record').show();
           $obj.parents('form').first().find('.new-record table tbody').html(data.new_record);
           $obj.parents('form').first().find('.new-record-select').hide();
           $obj.parent().children('[name=records_counter]').val(parseInt($obj.parent().children('[name=records_counter]').val()) + 1);
        }
        
        (function() {
            $(document).ready(function() {
                $(document).delegate(".zone-records table tbody [name^='record']", 'keydown change', function() {

                    $(this).parents('tr').find(':input').attr('name', function() {
                        if(this.name.indexOf('edit_') !== 0)
                            return 'edit_' + this.name;
                        return this.name;
                    });
                });
                
                $(document).delegate(".cancel-add-record", 'click', function() {
                    var $form = $(this).parents('form').first();
                    $form.find('.new-record-select').show();
                    $form.find('.new-record').hide();
                });
            });
        })(jQuery);
    </script>
{/literal}
