<div class="modal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form class="form-horizontal" action="" method="post" id="zone_form">
                <input type="hidden" name="dnsaction" value="createzone" />  
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                    <h4 class="modal-title">{$MGLANG->T('add_dns_zone')}</h4>
                </div>
                <div class="modal-body">
                    <div id="create_zone_area">
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->T('zone_client')}</label>
                            <div class="col-sm-7">
                                <input type="hidden" class="select2x" 
                                      {if $currentId} value="{$currentId}|{$currentClient}" data-act=""{else} {/if} />
                                <input type="hidden" name="client" data-act="getClientServices" data-do-not-close-the-modal=""  data-no-validate="1" value=""/>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->T('zone_service')}</label>
                            <div class="col-sm-7">
                                <select class="select2" id="si1" name="relateditem">
                                    {foreach from=$items item="item"}
                                        <option value="{$item.type}|{$item.relid}" {if (isset($relateditem) && $item.relid == $relateditem.relid && $item.type == $relateditem.type)}selected{/if} data-act="getClientServices" data-do-not-close-the-modal=""  data-no-validate="1" >{$item.name}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->T('zone_name')}</label>
                            <div class="col-sm-7">
                                <input class="form-control" type="text" name="zone_name" value="" required pattern="(.*\.)+.+" {*pattern="{literal}^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}{/literal}"*}/>
                            </div>
                        </div>
                        <div class="form-group"> 
                            <label class="control-label col-sm-3">{$MGLANG->T('ip')}</label>
                            <div class="col-sm-7">
                                <input class="form-control" type="text" name="zone_ip" value="" pattern="{$patterns.ip}"/>
                            </div>
                        </div>
                        <div class="form-group block-ip" {if count($pools) eq 0}style="display: none"{/if}> 
                            <label class="control-label col-sm-3">{$MGLANG->T('ip')}</label>
                            <div class="col-sm-7">
                                <input class="form-control" type="text" name="zone_ip_from_block" value="" required pattern="{$patterns.ip}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->T('selectRecordSet')}</label>
                            <div class="col-sm-7">
                                <select class="select2" name="recordSet">
                                    <option value="none"  >{$MGLANG->T('none')}</option>
                                    {foreach from=$sets item="aset"}
                                        <option value="{$aset->id}">{$aset->name}</option>
                                    {/foreach}
                                    <option value="" selected >{$MGLANG->T('defaultSet')}</option>
                                </select> 
                            </div>
                        </div>                            
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default btn-inverse" data-dismiss="modal">{$MGLANG->T('cancel')}</button>
                    <button type="button" class="btn btn-success btn-inverse" data-act="addZoneSave">{$MGLANG->T('add_zone')}</button>                                  
                </div>
            </form>
        </div>
    </div>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        (function ($) {
            $('[name=zone_ip]').change(function () {
                $(this).parents('form').first().find('.block-ip').removeClass('has-error').toggle(typeof $('option:selected', this).data('pool') != 'undefined');
            });

            try {
                $(".mg-wrapper .select2x").select2({
                    placeholder: "Search for a client",
                    minimumInputLength: 1,
                    containerCssClass: ' tpx-select2-container',
                    dropdownCssClass: ' tpx-select2-drop',
                    formatResult: createOption,
                    formatSelection: createSelection,
                    initSelection: initSelection,
                    ajax: {
                        url: "addonmodules.php?module=DNSManager2&mg-page=tools&mg-action=getClientsList&json=1",
                        dataType: 'json',
                        quietMillis: 250,
                        data: function (term, page) {
                            return {
                                q: term, // search term
                                page: page,
                            };
                        },
                        results: function (data, page) {
                            page = page || 1;
                            return {
                                results: data.response.items,
                                more: (page * 30) < data.response.total
                            };
                        },
                        cache: true
                    },
                });
            } catch (e) {
            }

        })(jQuery);

        function createOption(object, container) {  
            return "#" + object.id + " " + object.name;
        }
        var selectedObject;
        function createSelection(object, container) {         
            if(object.id){
                 var $el = $(this.element);
                var $next = $el.next();
                $next.val(object.id+'|'+object.name);
                $next.trigger('click');
                selectedObject = object;
                return "#" + object.id + " " + object.name;
            }else{
                $('input[name="client"').val(selectedObject.id + "|" + selectedObject.name);
                return "#" + selectedObject.id + " " + selectedObject.name;
            }   
        }
        
        function initSelection(element, callback) {
            callback({id: $(element).data('id'), name: $(element).data('name') });
        }
        
    </script>
{/literal}