<div class="module-main-header">
    <a href="index.php?m=DNSManager2" class="btn btn-back btn-icon" style="height: inherit;"><i class="fa fa-arrow-left"></i></a><h2>{$MGLANG->T('dns_manager')}</h2>
</div>
{if !$error}
<div class="module-content">
    <div class="module-header">   
    {if $tpl neq 'standard'}        
        {if $tpl eq 'pending'}
            {include file='status/pending.tpl'}
        {elseif $tpl eq 'notRegistered'}
            {include file='status/domainAvailable.tpl'}
        {elseif $tpl eq 'soaWarning'}
            {include file='status/soaWarning.tpl'}
        {elseif $tpl eq 'active'}
            {include file='status/active.tpl'}
        {/if}
        <div class="header-search">
            <div class="row-fluid-xs">
                <div class="fluid-100">
                    <div class="input-icon">
                        <input class="form-control searchTable" type="text" placeholder="{$MGLANG->T('search')}" data-search="">
                    </div>
                </div>
                <div class="fluid-0">
                    <button class="btn btn-primary" data-act="addRecord" data-query="zone_id={$zoneid}{foreach from=$records_count item="count" key="record"}&records[{$record}]={$count}{/foreach}"
                    {if $limits.total <= $records_count.total}disabled=""{/if}>{$MGLANG->T('add_record')}</button>
                    {if $enable_dnssec}
                        <a class="btn btn-danger"  href="index.php?m=DNSManager2&zone_id={$zoneid}&mg-action=dnssec" >{$MGLANG->T('dnssec')}</a>
                    {/if}
                </div>
            </div>
        </div> 
    {else}      
        <div class="header-title">
            <h1>{$MGLANG->T('edit_zone')} - {$zone_name}</h1>
        </div>
        <div class="header-actions">
            <div class="header-search">
                <div class="row-fluid-xs">
                    <div class="fluid-100">
                        <div class="input-icon">
                            <input class="form-control searchTable" type="text" placeholder="{$MGLANG->T('search')}" data-search="">
                        </div>
                    </div>
                    <div class="fluid-0">
                        <button class="btn btn-primary" data-act="addRecord" data-query="zone_id={$zoneid}{foreach from=$records_count item="count" key="record"}&records[{$record}]={$count}{/foreach}"
                        {if $limits.total <= $records_count.total}disabled=""{/if}>{$MGLANG->T('add_record')}</button>
                        
                        {if $enable_dnssec}
                            <a class="btn btn-danger"  href="index.php?m=DNSManager2&zone_id={$zoneid}&mg-action=dnssec" >{$MGLANG->T('dnssec')}</a>
                        {/if}
                    </div>
                </div>
            </div>         
        </div>   
    {/if}
    </div>                  
    <div class="module-body">
            <div class="row">
            {foreach from=$records_count item="count" key="record"}
                <div class="col-md-2 col-sm-4 col-xs-6" style="color: #45464C;"><b>{$record|strtoupper}</b> <span class="badge badge-success">{$count} / {if isset($limits[$record])}{$limits[$record]}{else}0{/if}</span></div>
            {/foreach}
            </div>
        <div class="section">
            <table class="table">
                <thead>
                    <tr>
                        <th>{$MGLANG->T('name')}</th>
                        <th>{$MGLANG->T('type')}</th>
                        <th {if $ttl_disabled}style="display: none;"{/if}>{$MGLANG->T('ttl')}</th>
                        <th>{$MGLANG->T('rdata')}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody id="edit-form">
                    <tr class="no-matches" style="display: none;"><td colspan="5" class="text-center">{$MGLANG->T('no_matches_found')}</td></tr>
                    {foreach from=$records item="record"}
                        <tr id="record{$counter}" class="record">
                            <td data-label="{$MGLANG->T('name')}" class="cell-sm-12 form-group">
                                <input type="text" class="form-control" name="record[{$counter}][name]" value="{if $record->type neq 'PTR' && $record->absoluteName}{$record->nameToAbsolute($zone_name)}{else}{$record->name}{/if}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','name')}" placeholder="{$MGLANG->T('name')}" required="" {if $record->type|strtoupper eq 'PTR'}disabled=""{/if}/>
                            </td>
                            <td data-label="{$MGLANG->T('type')}" class="cell-sm-12">
                                <input type="hidden" name="record[{$counter}][type]" value="{$record->type}"/>
                                <input class="form-control" type="text" value="{$record->type}" disabled="" title="{$MGLANG->absoluteT('addonAA','zones','record_type_info', $record->type)}"/>
                            </td>
                            <td data-label="{$MGLANG->T('ttl')}" class="cell-sm-12 form-group" {if $ttl_disabled}style="display: none;"{/if}>
                                <input class="form-control" type="number" name="record[{$counter}][ttl]" value="{$record->ttl}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','ttl')}" placeholder="{$MGLANG->T('ttl')}" required="" min="1" {if $record->type|strtoupper eq 'PTR' || $record->type|strtoupper eq 'ALIAS'}readonly{/if}/></td>
                            <td data-label="{$MGLANG->T('rdata')}" class="cell-sm-12">
                                {foreach from=$record->rdata key="field" item="value"}
                                    <input class="form-control table-input" type="text" name="record[{$counter}][field][{$field}]" value="{$value}" title="{$MGLANG->absoluteT('addonAA','zones','record_field_info',$record->type, $field)}" placeholder="{$MGLANG->absoluteT('addonCA','zones','record_field_placeholder',$record->type, $field)}" {if $record->type|strtoupper eq 'PTR'}disabled=""{/if}/>
                                {/foreach}
                            </td>
                            <td data-label="{$MGLANG->T('actions')}" class="cell-sm-12 cell-actions">
                                {if $record->type|strtoupper neq 'PTR'}<input name="record[{$counter}][line]" type="hidden" value="{$record->line}" />
                                {else}<input name="record[{$counter}][ip]" type="hidden" value="{$record->ip}" />
                                {/if}
                                <button type="button" class="btn btn-danger btn-icon" data-act="removeRecord" data-formid="record{$counter}" data-query="zone_id={$zoneid}" data-confirm-body="{$MGLANG->T('remove_zone_record_confirm')}" title="{$MGLANG->T('remove_record')}">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        {assign var="counter" value=$counter+1}
                    {foreachelse}
                        <tr  class="empty-record"><td colspan="5" align="center">{$MGLANG->T('there_is_no_record_within_this_zone')}</td></tr>
                    {/foreach}
                </tbody>
            </table>

            <button class="btn btn-success" type="button" data-act="editZoneSave" data-formid="edit-form" data-query="zone_id={$zoneid}">{$MGLANG->T('save_changes')}</button>
        </div>
    </div>              
</div>
{/if}

{literal}
    <script data-cfasync="false" type="text/javascript">
        MGVONLYEDITED = true;
        (function($){
            $(document).ready(function() {
                $(document).delegate("#edit-form [name^=record]", 'keydown', function() {
                    $(this).parents('tr').find(':input').attr('name', function() {
                        if(this.name.indexOf('edit_') !== 0)
                            return 'edit_' + this.name;
                        return this.name;
                    });
                });

                $(document).delegate("[data-search]", 'keyup', function() {
                    var search = $(this).val().toLowerCase();

                    if(!search.length) {
                        $('.no-matches').hide();
                        $('#edit-form > tr.record').show().css('display', "");
                        $('.no-matches').css('display', 'none');
                        if($('#edit-form > tr.record').length == 0){
                            $('.empty-record').removeClass('hidden');
                        }
                        return ;
                        return ;
                    }

                    $('#edit-form > tr.record').each(function() {
                        if ($('input', this).filter(function() {return this.value.toLowerCase().indexOf(search) > -1;}).length) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });

                    $('#edit-form > tr.no-matches').toggle(!$('#edit-form > tr.record:visible').length);
                    
                    if(!$('#edit-form > tr.record:visible').length == true){
                        $('.empty-record').addClass('hidden');
                    }
                    if(!search && $('#edit-form > tr.record').length == 0){
                         $('.empty-record').removeClass('hidden');
                    }
                });
            });
        })(jQuery);
    </script>
{/literal}
