<!DOCTYPE HTML>
<html>
<head>
<title>{$companyname} - {$id}</title>

<meta charset="{$charset}" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<link href="{$WEB_ROOT}/templates/{$template}/css/all.css" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="{$WEB_ROOT}/templates/{$template}/invoicequote/invoicequote.css" />
<link type="text/css" rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/invoicequote/invoicequote-responsive.css" />

<meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0;" /> 

<script src="{$BASE_PATH_JS}/jquery.min.js"></script>
<script src="{$BASE_PATH_JS}/bootstrap.min.js"></script>
        
{literal}
	<script>
		$(document).ready(function(){
		
		$("#quoteaccept").dialog({
		    autoOpen: false,
		    resizable: false,
		    width: 300,
		    modal: true,
			buttons: {'Agree & Accept': function() {
				    $("#quoteacceptfrm").submit();
				}}
		});
		
		});
	</script>
{/literal}

</head>

<body>

{if $error}

<div class="container-error">

			<div class="notice notice-error">
				<div class="inside">
					<p>{$LANG.invoiceserror}</p>
				</div>
			</div>
			
</div>			
			
{else}



<div class="container1">

	<div class="header">
		
		<div class="inner">
		
		<div class="left">
			
			<div class="logo">
				{if $logo}<img src="{$logo}" class="img-respond img-logo" />{else}{$companyname}{/if}
			</div>
			
			<div class="info">
				<span>{$LANG.quotenumber}: {$id}</span><br />
				{$LANG.quotedatecreated}: {$datecreated}<br />
				{$LANG.quotevaliduntil}: {$validuntil}<br />
				{if $stage eq "Delivered"}{$LANG.invoicessubtotal}: <strong class="totaldue1">{$subtotal}</strong>{/if}
			</div><!-- .info -->
			
		</div><!-- .left -->
		
		
		
		<div class="right">

			{if $stage eq "Delivered"}
			<p class="invoicestatus unpaid">{$LANG.quotestagedelivered}</p>
			
			<div class="payment">
				
				<div class="inner">
				
				<form style="display:inline">

					<input type="button" class="button1 colorbold" data-toggle="modal" data-target="#acceptQuoteModal" style="margin-right: 5px;" value="{$LANG.quoteacceptbtn}" />
				</form>
				<form style="display:inline" method="post" action="dl.php?type=q&amp;id={$quoteid}"><input type="submit" value="{$LANG.quotedlpdfbtn}" class="button1 colorlight" /></form>
				
				</div><!-- .inner -->
				
			</div><!-- .payment -->
			
			
			
			{elseif $stage eq "Accepted"}
				<p class="invoicestatus paid">{$LANG.quotestageaccepted}</p>
			{elseif $stage eq "On Hold"}
				<p class="invoicestatus refunded">{$LANG.quotestageonhold}</p>
				
			<div class="payment">
				
				<div class="inner">
				
				<form style="display:inline"><input type="button" class="button1 colorbold" style="margin-right: 5px;" value="{$LANG.quoteacceptbtn}" {if $accepttos}onclick="$('#quoteaccept').dialog('open')"{else}onclick="location.href='viewquote.php?id={$quoteid}&action=accept'" {/if} />
				</form>
				<form style="display:inline" method="post" action="dl.php?type=q&amp;id={$quoteid}"><input type="submit" value="{$LANG.quotedlpdfbtn}" class="button1 colorlight" /></form>
				
				</div><!-- .inner -->
				
			</div><!-- .payment -->
			
			{elseif $stage eq "Lost"}
				<p class="invoicestatus cancelled">{$LANG.quotestagelost}</p>
			{elseif $stage eq "Dead"}
				<p class="invoicestatus collections">{$LANG.quotestagedead}</p>
			{/if}			
		</div><!-- .right -->
		
		<div class="clear">&nbsp;</div>
		
		</div><!-- .inner -->
		
	</div><!-- .header -->
	
	
	<div class="inner">
	
		{if $smarty.get.paymentsuccess}
					<div class="notice notice-success">
						<div class="inside">
							<p>{$LANG.invoicepaymentsuccessconfirmation}</p>
						</div>
					</div>
		{elseif $smarty.get.pendingreview}
					<div class="notice notice-info">
						<div class="inside">
							<p>{$LANG.invoicepaymentpendingreview}</p>
						</div>
					</div>
		{elseif $smarty.get.paymentfailed}
					<div class="notice notice-error">
						<div class="inside">
							<p>{$LANG.invoicepaymentfailedconfirmation}</p>
						</div>
					</div>
		{elseif $offlinepaid}
					<div class="notice notice-success">
						<div class="inside">
							<p>{$LANG.invoiceofflinepaid}</p>
						</div>
					</div>
		{else}
		{/if}	
	
		{if $manualapplycredit}
		<div class="highlightbox redbox">
			
			<div class="inner">
			
				<form method="post" action="{$smarty.server.PHP_SELF}?id={$invoiceid}">
				<p>{$LANG.invoiceaddcreditdesc1} {$totalcredit}. {$LANG.invoiceaddcreditdesc2}</p>
				<p><input type="hidden" name="applycredit" value="true" />
				{$LANG.invoiceaddcreditamount}: <input type="text" name="creditamount" value="{$creditamount}" class="inputstyle" /> <input type="submit" value="{$LANG.invoiceaddcreditapply}" class="button1 colorbold" /></p>
				</form>
		
			</div><!-- .inner -->
		
		</div><!-- .highlightbox -->
		{/if}	
	
		<div class="addresses">
			
				<div class="address">
					
					<div class="inner">
					
						<h2>{$LANG.quoterecipient}</h2>
						<p>
		{if $clientsdetails.companyname}{$clientsdetails.companyname}<br />{/if}
		{$clientsdetails.firstname} {$clientsdetails.lastname}<br />
		{$clientsdetails.address1}, {$clientsdetails.address2}<br />
		{$clientsdetails.city}, {$clientsdetails.state}, {$clientsdetails.postcode}<br />
		{$clientsdetails.country}
						</p>
					
					</div><!-- .inner -->
					
				</div><!-- .address -->
				
				<div class="address last">
					
					<div class="inner">
					
						<h2>{$LANG.invoicespayto}</h2>
						<p>{$payto}</p>
					
					</div><!-- .inner -->
					
				</div><!-- .address -->
			
			<div class="clear">&nbsp;</div>
			
		</div><!-- .addresses -->
		
			<div class="highlightbox greybox">
				
				<div class="inner">				
					<p>{$proposal}</p>
					
					{if $agreetosrequired}<p class="center">{$LANG.ordererroraccepttos}</p>{/if}
				</div><!-- .inner -->
				
			</div><!-- .highlightbox -->
			
			
			
			
				<div class="table-responsive table-grey">	
<table>
<tr>
	<td id="invoiceitemsheading" align="center" width="50%" style="border:1px solid #cccccc;border-bottom:0px;"><strong>{$LANG.invoicesdescription}</strong></td>
    <td id="invoiceitemsheading" align="center" width="25%" style="border:1px solid #cccccc;border-left:0px;border-bottom:0px;"><strong>{$LANG.quotediscountheading}</strong></td>
    <td id="invoiceitemsheading" align="center" width="25%" style="border:1px solid #cccccc;border-left:0px;border-bottom:0px;"><strong>{$LANG.invoicesamount}</strong></td>
</tr>
{foreach key=num item=quoteitem from=$quoteitems}
<tr bgcolor=#ffffff>
	<td id="invoiceitemsrow" style="border:1px solid #cccccc;border-bottom:0px;">{$quoteitem.description}{if $quoteitem.taxed eq "true"} *{/if}</td>
    <td align="center" id="invoiceitemsrow" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;">{if $quoteitem.discount>0}{$quoteitem.discount} ({$quoteitem.discountpc}%){else} - {/if}</td>
    <td align="center" id="invoiceitemsrow" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;">{$quoteitem.amount}</td>
</tr>
{/foreach}
<tr>
	<td id="invoiceitemsheading" style="border:1px solid #cccccc;border-bottom:0px;"><div align="right">{$LANG.invoicessubtotal}:&nbsp;</div></td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;">&nbsp;</td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;"><strong>{$subtotal}</strong></td>
</tr>
{if $taxrate}
<tr>
	<td id="invoiceitemsheading" style="border:1px solid #cccccc;border-bottom:0px;"><div align="right">{$taxrate}% {$taxname}:&nbsp;</div></td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;">&nbsp;</td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;"><strong>{$tax}</strong></td>
</tr>
{/if}
{if $taxrate2}
<tr>
	<td id="invoiceitemsheading" style="border:1px solid #cccccc;border-bottom:0px;"><div align="right">{$taxrate2}% {$taxname2}:&nbsp;</div></td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;">&nbsp;</td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-bottom:0px;border-left:0px;"><strong>{$tax2}</strong></td>
</tr>
{/if}
<tr>
	<td id="invoiceitemsheading" style="border:1px solid #cccccc;"><div align="right">{$LANG.quotelinetotal}:&nbsp;</div></td>
    <td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-left:0px;border-left:0px;">&nbsp;</td>
	<td id="invoiceitemsheading" align="center" style="border:1px solid #cccccc;border-left:0px;"><strong class="totaldue">{$total}</strong></td>
</tr>
</table>			
			</div>
			
			
		
		{if $notes}
			<div class="highlightbox greybox nomarginbottom">
				
				<div class="inner">				
					<p><strong>{$LANG.invoicesnotes}</strong></p>
					<p>{$notes}</p>
				</div><!-- .inner -->
				
			</div><!-- .highlightbox -->
		{/if}
		
		{if $taxrate}<p>* {$LANG.invoicestaxindicator}</p>{/if}

	</div>
</div>

</div>
</div>



<div class="links">
	<a href="{$WEB_ROOT}/clientarea.php">{$LANG.invoicesbacktoclientarea}</a> | <a href="{$WEB_ROOT}/dl.php?type=q&amp;id={$quoteid}">{$LANG.quotedlpdfbtn}</a> | <a href="javascript:window.close()">{$LANG.closewindow}</a>
</div>	

{/if}

    <form method="post" action="viewquote.php?id={$quoteid}&amp;action=accept">
        <div class="modal fade" id="acceptQuoteModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">{$LANG.quoteacceptbtn}</h4>
                    </div>
                    <div class="modal-body">
                        <p>{$LANG.quoteacceptagreetos}</p>
                        <p class="text-center">
                            <label class="checkbox-inline">
                                <input type="checkbox" name="agreetos" />
                                {$LANG.ordertosagreement} <a href="{$tosurl}" target="_blank">{$LANG.ordertos}</a>
                            </label>
                        </p>
                        <small>{$LANG.quoteacceptcontractwarning}</small>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">{$LANG.cancel}</button>
                        <button type="submit" class="btn btn-primary">{$LANG.quoteacceptbtn}</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

</body>
</html>