<div class="modal modal-lg fade modal-tabed">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                <h4 class="modal-title">{if $server.edit}{$MGLANG->T('edit_server')}{else}{$MGLANG->T('add_server')}{/if}</h4>
                <ul class="nav nav-tabs text-right" role="tablist">
                    <li class="active"><a href="#general-tab" role="tab" data-toggle="tab">{$MGLANG->T('general')}</a></li>
                    <li><a href="#configuration-tab" role="tab" data-toggle="tab" {if !$server.edit}style="display: none;"{/if}>{$MGLANG->T('configuration')}</a></li>
                    <li><a href="#nameservers-tab" role="tab" data-toggle="tab" {if !$server.edit}style="display: none;"{/if}>{$MGLANG->T('nameservers')}</a></li>
                </ul>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    {if $server.edit}<input type="hidden" name="id" value="{$server.id}"/>{/if}
                    <div class="tab-content">
                        <!-- ========================================== GENERAL ====================================== -->
                        <div class="tab-pane active" id="general-tab">
                            <div class="form-group">
                                <label for="fi1" class="col-sm-3 control-label">{$MGLANG->T('name')}</label>
                                <div class="col-sm-9">
                                    <input id="iw1" type="text" class="form-control" name="name" value="{$server.name}" required="" pattern="{$patterns.no_white_chars_at_beginning}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="iw2" class="col-sm-3 control-label">{$MGLANG->T('module')}</label>
                                <div class="col-sm-9">
                                    <select name="server_module" class="select2" id="iw2" title="">
                                        <option value="">{$MGLANG->T('select_one')}</option>
                                        {foreach from=$available_submodules item="submodule"}
                                            <option value="{$submodule}" data-act="getAdditionalConfiguration|getModuleConfiguration" data-do-not-close-the-modal="" data-no-validate="1"
                                                    {if $server.module eq $submodule}selected=""{/if}>{$submodule}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs1" class="col-sm-3 control-label">{$MGLANG->T('allow_rdns')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs1" name="setting[allow_rdns]" {if $server.setting.allow_rdns eq 'on'}checked=""{/if}/>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="enable_dnssec_fs" class="col-sm-3 control-label">{$MGLANG->T('enable_dnssec')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="enable_dnssec_fs" name="setting[enable_dnssec]" {if $server.setting.enable_dnssec eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                                
                            <div class="form-group">
                                <label for="fs2" class="col-sm-3 control-label">{$MGLANG->T('allow_multiple_ptr')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs2" name="setting[allow_multiple_ptr]" {if $server.setting.allow_multiple_ptr eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs3" class="col-sm-3 control-label">{$MGLANG->T('enable_cache')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs3" name="setting[enable_cache]" {if $server.setting.enable_cache eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="additional-configuration">
                            {if $additional_configurtaion}
                                {$additional_config_html}
                            {/if}  
                            </div>
                        </div>
                        <!-- ========================================== CONFIGURATION ================================ -->
                        <div class="tab-pane module-configuration" id="configuration-tab">
                            {if $server.edit}
                                {$configuration_html}
                            {/if}
                        </div>
                        <!-- ========================================== NAMESERVERS =================================== -->
                        <div class="tab-pane" id="nameservers-tab">
                            <div class="row mgb10">
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[1][name]" class="form-control" placeholder="{$MGLANG->T('nameserver')} 1" value="{$server.nameserver[1].name}" pattern="{$patterns.hostname}"/>
                                </div>
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[1][ip]" class="form-control" value="{$server.nameserver[1].ip}" placeholder="{$MGLANG->T('ip_address_of_nameserver')} 1" pattern="{$patterns.ip}"/> 
                                </div>
                            </div>
                            <div class="row mgb10">
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[2][name]" class="form-control" placeholder="{$MGLANG->T('nameserver')} 2" value="{$server.nameserver[2].name}" pattern="{$patterns.hostname}"/>
                                </div>
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[2][ip]" class="form-control" value="{$server.nameserver[2].ip}" placeholder="{$MGLANG->T('ip_address_of_nameserver')} 2" pattern="{$patterns.ip}"/>  
                                </div>
                            </div>
                            <div class="row mgb10">
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[3][name]" class="form-control" placeholder="{$MGLANG->T('nameserver')} 3" value="{$server.nameserver[3].name}" pattern="{$patterns.hostname}"/>
                                </div>
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[3][ip]" class="form-control" value="{$server.nameserver[3].ip}" placeholder="{$MGLANG->T('ip_address_of_nameserver')} 3" pattern="{$patterns.ip}"/> 
                                </div>
                            </div>
                            <div class="row mgb10">
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[4][name]" class="form-control" placeholder="{$MGLANG->T('nameserver')} 4" value="{$server.nameserver[4].name}" pattern="{$patterns.hostname}"/>
                                </div>
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[4][ip]" class="form-control" value="{$server.nameserver[4].ip}" placeholder="{$MGLANG->T('ip_address_of_nameserver')} 4" pattern="{$patterns.ip}"/> 
                                </div>
                            </div> 
                            <div class="row mgb10">
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[5][name]" class="form-control" placeholder="{$MGLANG->T('nameserver')} 5" value="{$server.nameserver[5].name}" pattern="{$patterns.hostname}"/>
                                </div>
                                <div class="col-sm-6 form-group" style="margin: 0px;">
                                    <input name="ns[5][ip]" class="form-control" value="{$server.nameserver[5].ip}" placeholder="{$MGLANG->T('ip_address_of_nameserver')} 5" pattern="{$patterns.ip}"/> 
                                </div>
                            </div>
                        </div>          
              </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('close')}</button>
                <button type="button" class="btn btn-primary btn-inverse" data-act="testConnection" data-do-not-close-the-modal="" data-formid="configuration-tab">{$MGLANG->T('test_connection')}</button>
                {if $server.edit}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="serverSave">{$MGLANG->T('save_changes')}</button>
                {else}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="serverSave">{$MGLANG->T('add_server')}</button>
                {/if}
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal --> 