<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li><a {*href="addonmodules.php?module=DNSManager2&mg-page=tools&mg-action=import"*} data-act="import">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'import')}</a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'import')} #{$importid}</li>
</ul>
<table class="table table-striped" id="import-list">
    <thead>
        <tr>
            <th>{*<div class="checkbox"><input type="checkbox" class="select_all"/><input type="hidden" name="id" value="{$importid}" /></div>*}</th>
            <th>{$MGLANG->T('zone')}</th>
            <th>{$MGLANG->T('ip')}</th>
            <th>{$MGLANG->T('status')}</th>
            {*<th>{$MGLANG->T('client')}</th>*}
            {*<th>{$MGLANG->T('related_item')}</th>*}
            <th></th>
        </tr>
    </thead>
    <tbody>
        
    </tbody>
</table>

<div class="well">
    <a class="btn btn-primary btn-inverse" data-act="backupImportZones" data-formid="import-list" data-dt="1" data-query="id={$importid}">{$MGLANG->T('import_zones')}</a>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        
        function backupImportZonesCallback(){
            var currentPage = DNSgetCurrentPageNumber();
            jQuery('#import-list').DataTable().ajax.reload();
            DNSJumpToSpecificPageNumber(currentPage);
        }

        function setRowsID(setting) {
            $('#import-list tbody tr').each( function(){
                var id = $(this).find('.row-id').data('id');
                $(this).attr('id', id);
            });

            $(".mg-wrapper .checkbox input[type='checkbox']").iCheck({
                checkboxClass: 'checkbox-styled',
                radioClass: 'radio-styled',
                increaseArea: '20%'
            });
            
            $('#import-list .checkbox').iCheck('check');
        }
        
        jQuery(document).ready(function(){
            jQuery('#import-list').dataTable({
                drawCallback: function () {
                    setRowsID();
                    replaceEmptyRowDataTable();
                },
                serverSide: true,
                searchDelay: 800,
                autoWidth: false,
                ordering: false,
                ajax: function(data, callback, settings){                  
                    var filters = $('#table-filters :input').serializeArray();
                    JSONParser.request(
                        'refreshImportTable'
                        , $.merge(filters, [
                            {name: 'limit', value: data.length},
                            {name: 'offset', value: data.start},
                            {name: 'search', value: data.search.value},
                            {name: 'id', value: {/literal}{$importid}{literal}},

                        ]),
                        function(data) {
                            callback(data);
                            jQuery('.mg-wrapper [title]').bstooltip();
                            addCustomPagination('import-list', 1);
                        }
                    );
                },
                columns: [
                    { orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                ],
                pagingType: "simple_numbers",
                aLengthMenu: [
                    [5, 10, 25, 50, 75, 100],
                    [5, 10, 25, 50, 75, 100]
                ],
                iDisplayLength: 10,
                "oLanguage": {
                    "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                    "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                    "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                    "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                    "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                    "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                    "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                    "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                    "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                }
            });
        });
    </script>
{/literal}
