<div class="module-content">
    <div class="module-header">
        <div class="header-title">
            <h1>{$MGLANG->T('dns_zones')}</h1>
        </div>
        <div class="inline-block">
            {*<div class="header-search">*}
            <div class="pull-right">
                {*<div class="mg-ca-buttons">*}
                <span class="mg-ca-headerbuttons"><button type="button" class="btn btn-primary mg-ca-header-actions" name="setRecordsButton" data-act="setRecords" data-formid="zone-list" style="display:none">{$MGLANG->T('set_dns_records')}</button></span>
                {if $manageRecordsSets eq 'on'}<span class="mg-ca-headerbuttons"><a class="btn btn-primary mg-ca-header-actions" name="manageRecordsSets" href="index.php?m=DNSManager2&mg-page=setsdns">{$MGLANG->T('sets_dns')}</a></span>{/if}
                {if $manage_rdns eq 'true'}<span class="mg-ca-headerbuttons"><a class="btn btn-primary mg-ca-header-actions" name="manage_rdns" href="index.php?m=DNSManager2&mg-action=manageRDNS">{$MGLANG->T('manage_rdns')}</a></span>{/if}
                {if $clientarea_import_export eq 'on'}<span class="mg-ca-headerbuttons"><a class="btn btn-primary mg-ca-header-actions" name="clientareaBackups" href="index.php?m=DNSManager2&mg-action=backups">{$MGLANG->T('clientarea_import_export')}</a></span>{/if}
                {*</div>*}
            </div>
            <div class="pull-right searchTableMG-CA" >
                <div class="input-icon">
                    {*<input class="form-control searchTable searchTableMG-CA" type="text" placeholder="{$MGLANG->T('search')}" data-search="">*}
                    <input class="form-control searchTable"" type="text" placeholder="{$MGLANG->T('search')}" data-search="">
                </div>

            </div>

        </div>

    </div>
    <div class="module-body">
        <form class="form-horizontal" id="zone-list">
            <div class="section">
                <input type="hidden" name="wipe">
                <input type="hidden" name="setRecord">
                <div class="panel-group" id="zones-list">
                    {foreach from=$groups key="group_name" item="group" name="groups_loop"}
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4 class="header-title">
                                    <a data-toggle="collapse" data-parent="#products-list" href="#panel-{$smarty.foreach.groups_loop.index}" aria-expanded="true" aria-controls="collapseOne">
                                        <i class="fa fa-angle-down"></i><i class="fa fa-angle-up"></i>
                                        {if !$group->product_id && !$group->product_group_name && !$group->product_name && !$group->domain}{$group->groupKey}{else}
                                        {if $showProductName == "on"}{$group->product_name} {else}  {$MGLANG->T('service')} #{$group->product_id}{/if} - {$group->domain}
                                {/if}
                            </a>
                        </h4>
                        <div class="header-actions">  
                            <div class="badge badge-success">{$MGLANG->T('zones')}: <span>{$groups_info[$group->groupKey].zones_count}/{$groups_info[$group->groupKey].zones_available}</span></div>
                            <button style="margin-left: 10px;" {if $groups_info[$group->groupKey].full}disabled=""{/if} class="btn btn-primary btn-sm" type="button" data-act="addZone" data-query="type={$groups_info[$group->groupKey].type}&relid={$groups_info[$group->groupKey].relid}">{$MGLANG->T('add_new_zone')}</button>
                        </div>
                    </div>
                    <div id="panel-{$smarty.foreach.groups_loop.index}" class="panel-collapse collapse in">
                        <ul class="panel-list list-info">
                            {foreach from=$group->group item="zone"}
                                {if $zone.zone_name neq ''}
                                    <li>
                                        {if $zone.zone_status eq '1' && $manageRecordsSets}
                                            <div class="checkbox" name="multiCheckbox" style="width:2%;display:inline-block;margin-bottom:-8px;">
                                                <input class="sel" type="checkbox" name="zone[checked][{$zone.zone_id}]"/>
                                            </div>
                                        {/if}
                                        <a class="mg-ca-zone" href="https://{$zone.zone_name}">{$zone.zone_name}</a>
                                        <div class="list-actions">
                                            {if $zone.zone_status eq '1'}
                                                <a class="btn btn-icon" href="index.php?m=DNSManager2&mg-action=editZone&zone_id={$zone.zone_id}" type="button" {*data-act="editZone" data-query="zone_id={$zone.zone_id}"*} title="{$MGLANG->T('edit_zone')}"><i class="fa fa-edit"></i></a>
                                                {else}
                                                <a class="btn btn-icon" type="button" data-act="createZone" data-query="zone_id={$zone.zone_id}" title="{$MGLANG->T('create_zone')}"><i class="fa fa-plus"></i></a>
                                                {/if}
                                            <button class="btn btn-danger btn-icon" type="button" data-act="removeZone" data-query="zone_id={$zone.zone_id}" data-confirm-body="{$MGLANG->T('remove-zone-confirm')}" title="{$MGLANG->T('delete_zone')}"> <i class="fa fa-trash"></i></button>
                                        </div>
                                    </li>
                                {else}
                                    <li>
                                        {$MGLANG->T('you_have_no_zone_within_this_group')}
                                    </li>
                                {/if}
                            {/foreach}
                        </ul>
                    </div>
                </div>
            {foreachelse}
                <div class="nozones">{$MGLANG->T('you have no zones available')}</div>
            {/foreach}
        </div>
    </div>
</form>    
</div>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        (function ($) {
            $(document).delegate('[data-search]', 'keyup', function () {
                var search = $(this).val();

                if (!search.length) {
                    $('#zones-list > .panel').show().css('display', "");
                    $('#zones-list > .panel ul li').show().css('display', "");
                    return;
                }

                $('.panel-collapse.collapse').each(function () {
                    if (!$(this).hasClass("in")) {
                        $(this).parent().find('a').first().trigger('click');
                    }
                });

                $('#zones-list > .panel ul li').each(function () {
                    if ($('a:contains("' + search + '")', this).length) {
                        $(this).show().css('display', "");
                        $(this).addClass('visible');
                    } else {
                        $(this).hide();
                        $(this).removeClass('visible');
                    }
                });
                var anyShow = false;
                $('#zones-list > .panel').each(function () {
                    if ($('ul li.visible', this).length) {
                        $(this).show().css('display', "");
                        anyShow = true;
                    } else {
                        $(this).hide();
                    }
                });

                if(anyShow === false)
                {
                    if(!$('.nozones').length)
                    {
                        $('#zones-list').append('<div class="nozones">{/literal}{$MGLANG->T('you have no zones available')}{literal}</div>');
                    }

                }
                else
                {
                    $('.nozones').remove();
                }

            });

            $('div[name="multiCheckbox"]').on('ifChanged', function (event) {
                var buttonHidden = true;
                var checkboxes = $('input[name*="zone[checked]"]');
                checkboxes.each(function (key, val) {
                    if (val.checked == true)
                    {
                        buttonHidden = false;
                    }
                });
                if (!buttonHidden)
                {
                    jQuery('a[name="manageRecordsSets"]').hide();
                    jQuery('a[name="manage_rdns"]').hide();
                    jQuery('button[name="setRecordsButton"]').show();
                } else
                {
                    jQuery('button[name="setRecordsButton"]').hide();
                    jQuery('a[name="manageRecordsSets"]').show();
                    jQuery('a[name="manage_rdns"]').show();
                }
            });
            jQuery('button[name="setRecordsButton"]').click(function () {
                jQuery('input[name="wipe"]').val(false);
            });

        })(jQuery);
    </script>
{/literal}
