<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'dashboard', 'label')}</li>
</ul>

{if $tutorial}
<div class="alert alert-info">
    Freshly installed module needs to be configured, here are the basic steps you need to undertake:<br />
    1. Configure client area template, logs setttings and notifications under 'Settings' → 'Global Settings'<br />
    2. Set up cron job, which can be found under 'Tools' → 'Cron'<br />
    3. Configure cron jobs settings and time interval on the same page as mentioned above.<br />
    4. Configure DNS servers used under 'Settings' →  'Servers'<br />
    5. Configure packages, which will define relations between items and settings, under 'Settings' → 'Packages'<br />
    <br />
    For more information visit our <a href="https://www.docs.modulesgarden.com/DNS_Manager_For_WHMCS">Wiki</a>.<br />
    <br />
    <a class="btn btn-info btn-inverse" data-act="disableTutorial" data-confirm-body="{$MGLANG->T('are_you_sure_that_you_want_to_hide_this_guide')}">Hide Guide</a>
</div>
{/if}

<div class="row">
    <div class="col-md-6">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title">{$MGLANG->T('servers')} <small>{$MGLANG->T('zones_used')}</small></h3>
            </div>
            <div class="panel-body">
                <table class="table table-striped">
                    <tbody>
                        {foreach from=$zones_used item="zone"}
                            <tr>
                                <td class="mg-firstDashbordColumn">{$zone.name}</td>
                                <td><span class="badge badge-info">{$zone.c}</span></td>
                            </tr>
                        {foreachelse}
                            <tr>
                                <td colspan="2">{$MGLANG->T('no_zone_in_use')}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title">{$MGLANG->T('email_send')} <small>{$MGLANG->T('last_week')}</small></h3>
            </div>
            <div class="panel-body">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <td class="mg-firstDashbordColumn">{$MGLANG->T('zone_created')}</td>
                            <td><span class="badge badge-info">{$email_zone_created}</span></td>
                        </tr>
                        <tr>
                            <td>{$MGLANG->T('zone_edited')}</td>
                            <td><span class="badge badge-info">{$email_zone_edited}</span></td>
                        </tr>
                        <tr>
                            <td>{$MGLANG->T('zone_removed')}</td>
                            <td><span class="badge badge-info">{$email_zone_removed}</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
    
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title">{$MGLANG->T('notifications')}</h3>
            </div>
            <div class="panel-body">
                <table class="table table-hover table-striped" id="notifications-table">
                    <thead>
                        <tr>
                            <th>{$MGLANG->T('notification')}</th>
                            <th>{$MGLANG->T('typeh')}</th>
                            <th>{$MGLANG->T('date')}</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
            
{literal}
    <script data-cfasync="false" type="text/javascript">
        jQuery(document).ready(function(){
            var last;
            jQuery('#table-filters').change(function() {
                jQuery('#notifications-table').DataTable().ajax.reload();
            });
            
            jQuery('#notifications-table').dataTable({

                  drawCallback:replaceEmptyRowDataTable,
                  serverSide: true,
                //  searching: false,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          data.start = 0;
                      }
                      last = data.length;
                      
                      var filters = $('#table-filters :input').serializeArray();
                      JSONParser.request(
                          'refreshNotificationTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('[data-toggle="tooltip"]').tooltip();
                          }
                      );
                  },
                  columns: [
                      {name: 'value'}
                      ,{name: 'type'}
                      ,{name: 'date'}
                  ],
                  paging: 3,
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25],
                      [5, 10, 25]
                  ],
                  pageLength: 10,
                  length: 3,
                  iDisplayLength: -1,
                  // sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                  order: [[2, "desc"]],
                  "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   }
            });
            $('.dataTables_info').parent().attr('class', 'col-md-6');
            $('.dataTables_paginate').parent().attr('class', 'col-md-6');
        });
    </script>
{/literal}