<div class="modal fade modal-lg modal-tabed" id="edit-set-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                
                <h4 class="modal-title text-left">{if $edit}{$MGLANG->T('edit_package')}{else}{$MGLANG->T('add_package')}{/if}</h4>
                <ul class="nav nav-tabs text-right" role="tablist">
                    <li class="active"><a href="#general-tab" role="tab" data-toggle="tab">{$MGLANG->T('general')}</a></li>
                    <li><a href="#items-tab" role="tab" data-toggle="tab">{$MGLANG->T('items')}</a></li>
                    <li><a href="#server-tab" role="tab" data-toggle="tab">{$MGLANG->T('servers')}</a></li>
                    <li><a href="#records-tab" role="tab" data-toggle="tab">{$MGLANG->T('Records')}</a></li>
                    <li><a href="#registrars-tab" role="tab" data-toggle="tab">{$MGLANG->T('registrars')}</a></li>
                    <li><a href="#notifications-tab" role="tab" data-toggle="tab">{$MGLANG->T('notifications')}</a></li>
                </ul>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    {if $edit}<input type="hidden" name="packageid" value="{$package.id}" />{/if}
                    <div class="tab-content">
                        <!-- ========================================== GENERAL ====================================== -->
                        <div class="tab-pane active" id="general-tab">
                            <div class="form-group">
                                <label for="fi1" class="col-sm-3 control-label">{$MGLANG->T('name')}</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="fi1" name="name" value="{$package.name}" required pattern="{$patterns.no_white_chars_at_beginning}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fis1" class="col-sm-3 control-label">{$MGLANG->T('own_zones_per_item')}</label>
                                <div class="col-sm-9">
                                    <input type="number" class="form-control" id="fis1" name="settings[own_zones_per_item]" value="{$package.setting.own_zones_per_item}" min="1" required/>
                                </div>
                            </div>
                            {*<div class="form-group">
                                <label for="fis2" class="col-sm-3 control-label">{$MGLANG->T('enable_rdns')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fis2" name="settings[enable_rdns]" {if $package.setting.enable_rdns eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs3" class="col-sm-3 control-label">{$MGLANG->T('allow_multiple_ptr')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs3" name="settings[allow_multiple_ptr]" {if $package.setting.allow_multiple_ptr eq 'on'}checked=""{/if}/>
                                </div>
                            </div>*}
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('zone_creation_automation')}</h3>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs4" class="col-sm-3 control-label">{$MGLANG->T('new_item')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs4" name="settings[zone_automation_new_item]" {if $package.setting.zone_automation_new_item eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs5" class="col-sm-3 control-label">{$MGLANG->T('pending_transfer_domain')}</label>
                                <div class="col-sm-1 checkbox">
                                    <input type="checkbox" id="fs5" name="settings[zone_automation_pending_transfer_domain]" {if $package.setting.zone_automation_pending_transfer_domain eq 'on'}checked=""{/if}/>
                                </div>           
                                <div class="col-sm-2" id="si1" {if $package.setting.zone_automation_pending_transfer_domain neq 'on'} style="display:none"{/if}>
                                    <select class="select2"  name="settings[zone_automation_pending_transfer_domain_time]">
                                        {if $package.setting.zone_automation_pending_transfer_domain_time}
                                            <option value="{$package.setting.zone_automation_pending_transfer_domain_time}" selected>{$package.setting.zone_automation_pending_transfer_domain_time}</option> 
                                            {if $package.setting.zone_automation_pending_transfer_domain_time eq 'Pre'}
                                                <option value="After">After</option>
                                            {else}
                                                <option value="Pre">Pre</option>
                                            {/if}
                                        {else}
                                            <option value="Pre">Pre</option>
                                            <option value="After">After</option>
                                        {/if}
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs6" class="col-sm-3 control-label">{$MGLANG->T('pending_registration_domain')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs6" name="settings[zone_automation_pending_registration_domain]" {if $package.setting.zone_automation_pending_registration_domain eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs7" class="col-sm-3 control-label">{$MGLANG->T('domain_with_dns_management')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs7" name="settings[zone_automation_domain_with_dns_management]" {if $package.setting.zone_automation_domain_with_dns_management eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs8" class="col-sm-3 control-label">{$MGLANG->T('update_existed_zone')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs7" name="settings[update_existed_zone]" {if $package.setting.update_existed_zone eq 'on'}checked=""{/if}/>
                                </div>
                            </div>
                        </div>
                        <!-- ========================================== ITEMS ====================================== -->
                        <div class="tab-pane" id="items-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12">                                    
                                        <h3 class="diblock">{$MGLANG->T('domains')}</h3> 
                                        <span class="btn btn-primary btn-inverse btn-xs select-all">{$MGLANG->T('select_all')}</span>
                                    </div>
                                    <table class="table table-striped">
                                        <tbody>
                                            {foreach from=$domains item="four_domains"}
                                                <tr>
                                                    {foreach from=$four_domains item="domain"}
                                                        <td>
                                                            {if $domain neq ''}
                                                            {*<label class="checkbox checkbox-inline" {if !in_array($domain.extension, $package_domains) && $domain.packageid neq ''}title="{$MGLANG->T('already_in_package')}{$domain.packagename}" style="cursor: not-allowed;"{/if}><input class="allowedDomain" type="checkbox" name="domains[{$domain.encodedExtension}]" {if in_array($domain.extension, $package_domains)}checked=""{elseif $domain.packageid neq ''}disabled="" data-let-it-go{else}data-let-it-go{/if} /> {$domain.extension}</label>*}
                                                            <label class="checkbox checkbox-inline" {if !in_array($domain.id, $package_domains) && $domain.packageid neq ''}title="{$MGLANG->T('already_in_package')}{$domain.packagename}" style="cursor: not-allowed;"{/if}><input class="allowedDomain" type="checkbox" name="domains[{$domain.id}]" {if in_array($domain.id, $package_domains)}checked=""{elseif $domain.packageid neq ''}disabled="" data-let-it-go{else}data-let-it-go{/if} /> {$domain.extension}</label>
                                                            {/if}
                                                        </td>
                                                    {/foreach}
                                                </tr>
                                            {foreachelse}
                                                <tr><td>{$MGLANG->T('there_is_no_domain_configured_yet')}</td></tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12">                                    
                                        <h3 class="diblock">{$MGLANG->T('products')}</h3> 
                                        <span class="btn btn-primary btn-inverse btn-xs select-all">{$MGLANG->T('select_all')}</span>
                                    </div>
                                    <table class="table table-striped">
                                        <tbody>
                                            {foreach from=$products item="two_products"}
                                                <tr>
                                                {foreach from=$two_products item="product"}
                                                    <td style="width: 50%;">
                                                        {if $product neq ''}
                                                        <label class="checkbox checkbox-inline" {if !in_array($product.id, $package_products) && $product.packageid neq ''}title="{$MGLANG->T('already_in_package')}{$product.packagename}" style="cursor: not-allowed;"{/if}><input type="checkbox" name="products[{$product.id}]" {if in_array($product.id, $package_products)}checked=""{elseif $product.packageid neq ''}disabled="" data-let-it-go{else}data-let-it-go{/if}/> {$product.name}</label>
                                                        {/if}
                                                    </td>
                                                {/foreach}
                                                </tr>
                                            {foreachelse}
                                                <tr><td>{$MGLANG->T('there_is_no_product_configured_yet')}</td></tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12">
                                        <h3 class="diblock">{$MGLANG->T('products_addons')}</h3> 
                                        <span class="btn btn-primary btn-inverse btn-xs select-all">{$MGLANG->T('select_all')}</span>
                                    </div>
                                    <table class="table table-striped">
                                        <tbody>
                                            {foreach from=$addons item="two_addons"}
                                                <tr>
                                                {foreach from=$two_addons item="addon"}
                                                    <td style="width: 50%;">
                                                        {if $addon neq ''}
                                                        <label class="checkbox checkbox-inline" {if !in_array($addon.id, $package_addons) && $addon.packageid neq ''}title="{$MGLANG->T('already_in_package')}{$addon.packagename}" style="cursor: not-allowed;"{/if}><input type="checkbox" name="addons[{$addon.id}]" {if in_array($addon.id, $package_addons)}checked=""{elseif $addon.packageid neq ''}disabled="" data-let-it-go{else}data-let-it-go{/if}/> {$addon.name}</label>
                                                        {/if}
                                                    </td>
                                                {/foreach}
                                                </tr>
                                            {foreachelse}
                                                <tr><td>{$MGLANG->T('there_is_no_product_addon_configured_yet')}</td></tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12">
                                        <h3 class="diblock">{$MGLANG->T('other')}</h3> 
                                    </div>
                                    <table class="table table-striped">
                                        <tbody>
                                            <tr>
                                                <td><label class="checkbox checkbox-inline checkbox-other" {if !empty($others) neq '' && $others.packageid neq $package.id}title="{$MGLANG->T('already_in_package')}{$others.packagename}" style="cursor: not-allowed;"{/if}><input type="checkbox" name="other[0]" {if $others.packageid eq $package.id && !empty($others)}checked=""{elseif !empty($others)}disabled="" data-let-it-go{else}data-let-it-go{/if} /> {$MGLANG->T('allow_to_create_own_zones')}</label></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    
                                </div>
                            </div>
                        </div>
                        <!-- ========================================== SERVER ====================================== -->
                        <div class="tab-pane" id="server-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-striped package-servers-table">
                                        <thead>
                                            <tr>
                                                <th>{$MGLANG->T('name')}</th>
                                                <th>{$MGLANG->T('type')}</th>
                                                <th>{$MGLANG->T('packages')}</th>
                                                <th>{$MGLANG->T('rdns')}</th>
                                                <th>{$MGLANG->T('multiple_ptr')}</th>
                                                <th>{$MGLANG->T('status')}</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="nobody-is-here" {if count($package.servers)}style="display: none;"{/if}>
                                                <td colspan="7" class="text-center">{$MGLANG->T('there_is_no_server_added_to_this_package')}</td>
                                            </tr>
                                        {foreach from=$package.servers item="ps" key="k"}
                                            {assign var="server" value=$ps->getServer()}
                                            <tr>
                                                <td>{$server->name}</td>
                                                <td>{$server->module}</td>
                                                <td>{$server_packages[$k]}</td>
                                                <td>{if $server->getSettings('allow_rdns') eq 'on'}<span class="label label-success">{$MGLANG->T('enabled')}</span>{else}<span class="label label-danger">{$MGLANG->T('disabled')}</span>{/if}</td>
                                                <td>{if $server->getSettings('allow_multiple_ptr') eq 'on'}<span class="label label-success">{$MGLANG->T('enabled')}</span>{else}<span class="label label-danger">{$MGLANG->T('disabled')}</span>{/if}</td>
                                                <td>{if $server->status eq 1}<span class="label label-success">{$MGLANG->T('enabled')}</span>{else}<span class="label label-danger">{$MGLANG->T('disabled')}</span>{/if}</td>
                                                <td>
                                                    <input type="hidden" name="servers[]" value="{$server->id}" />
                                                    <a class="btn btn-danger btn-inverse" onclick="$(this).parents('.tab-pane').first().append('<input type=\'hidden\' name=\'servers_delete[]\' value=\'{$server->id}\' />'); removeServerRow($(this), {$server->id});" title="{$MGLANG->T('remove')}"><span class="glyphicon glyphicon-remove"></span></a>
                                                </td>
                                            </tr>
                                        {/foreach}
                                        </tbody>
                                    </table>
                                    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-5 col-xs-9">
                                    <select class="select2" name="add_server">
                                    {foreach from=$servers item="server"}
                                        <option value="{$server->id}" {if in_array($server->id, $package.servers_keys)}disabled{/if} >{$server->name}</option>
                                    {/foreach}
                                    </select>
                                </div>
                                <div class="col-md-7 col-xs-3">
                                    <a class="btn btn-success btn-inverse" data-act="addPackageServer" data-formid="server-tab" data-do-not-close-the-modal="" title="{$MGLANG->T('add_server')}"><span class="glyphicon glyphicon-plus"></span></a>
                                </div>
                            </div>
                        </div>
                        <!-- ========================================== RECORDS ====================================== -->
                        <div class="tab-pane" id="records-tab">
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('restrictions')}</h3>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs8" class="col-sm-3 control-label">{$MGLANG->T('allow_record_types')}</label>
                                <div class="col-sm-9">
                                    <select name="allowed_record_types[]" id="allowedRecordTypes" multiple="" class="select2" id="fs8">
                                        {foreach from=$available_record_types item="record"}
                                            <option value="{$record}" {if in_array($record, $package.setting.allowed_record_types_keys) == true}selected=""{/if}>{$record}</option>
                                        {/foreach}
                                    </select>
                                    <ul class="list-group" id="DNSRecordValidationAlert" style="word-wrap:break-word;">
                                    </ul>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('records_limit')}</h3>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs9" class="col-sm-3 control-label">{$MGLANG->T('total')}</label>
                                <div class="col-sm-9">
                                    <input type="number" class="form-control" id="fs9" name="record_limit" value="{$record_limit}" min="1" required/>
                                </div>
                            </div>
                            <div class="row reords-limit">
                                <div class="template hidden">
                                    <div class="col-sm-4 col-xs-6 record-:record_name:">
                                        <div class="form-group">
                                            <label for="rl:number:" class="col-md-5 col-xs-3 control-label">:record_name:</label>
                                            <div class="col-md-7 col-xs-9">
                                                <input type="number" class="form-control" id="rl:number:" name=":name:" min="-1" value="1">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {foreach from=$package.setting.allowed_record_types item="record_limit" key="record_name" name="rfor"}
                                    <div class="col-md-4 record-{$record_name}">
                                        <div class="form-group">
                                            <label for="rl{$smarty.foreach.rfor.index}" class="col-md-5 col-sm-3 control-label">{$record_name}</label>
                                            <div class="col-md-7 col-sm-9">
                                                <input type="number" class="form-control" id="rl{$smarty.foreach.rfor.index}" name="settings[allowed_record_types][{$record_name}]" min="-1" value="{$record_limit}">
                                            </div>
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('dns_record_sets')}</h3>
                                </div>
                            </div>    
                            <div class="form-group">
                                <label for="fs10" class="col-sm-3 control-label">{$MGLANG->T('default_dns_record_set')}</label>
                                <div class="col-sm-9">
                                    <select name="default_dns_record_set" class="select2" id="fs10">
                                        <option value="">{$MGLANG->T('none')}</option>
                                        {foreach from=$sets item="set"}
                                            <option value="{$set->id}" {if $set->id eq $package.defaultset}selected=""{/if}>{$set->name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs11" class="col-sm-3 control-label">{$MGLANG->T('dns_record_sets')}</label>
                                <div class="col-sm-9">
                                    <select name="settings[dns_record_set][]" class="select2" id="fs11"  multiple="">
                                        {foreach from=$sets item="set"}
                                            <option value="{$set->id}" {if  in_array($set->id, $package.setting.dns_record_set)}selected=""{/if}>{$set->name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div> 
                            <div class="form-group" style="display: none;">
                                <label for="fs12" class="col-sm-3 control-label">{$MGLANG->T('client_can_use_sets')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs12" name="settings[client_can_use_sets]" {if $package.setting.client_can_use_sets == 'on'}checked=""{/if} onchange="$(this).parents('.tab-pane').first().find('.allowed-sets').toggle($(this).is(':checked'));" />
                                </div>
                            </div>
                            <div class="form-group allowed-sets" style="display: none;" {*{if $package.setting.client_can_use_sets neq 'on'}style="display: none;"{/if}*}>
                                <label for="fs13" class="col-sm-3 control-label">{$MGLANG->T('allowed_sets')}</label>
                                <div class="col-sm-9">
                                    <select name="available_dns_record_sets[]" id="fs13" class="select2" multiple="">
                                    {foreach from=$sets item="set"}
                                        <option value="{$set->id}" {if in_array($set->id, $package_sets)}selected=""{/if} >{$set->name}</option>
                                    {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!-- ========================================== REGISTRARS ====================================== -->
                        <div class="tab-pane" id="registrars-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="alert alert-info" role="alert">{$MGLANG->T('registrarsDescription')}</div>
                                    {if $mocksNotReadable || $functionsNotWritable}
                                        <ul class="list-group">
                                            <li class="list-group-item list-group-item-danger">
                                                {$MGLANG->T('to_enable_the_feature')}:<br />
                                                {if $mocksNotReadable}
                                                    {$MGLANG->T('please_set')} {$mocksPath} {$MGLANG->T('directory_as')} {$MGLANG->T('readable')}<br />
                                                {/if}
                                                {if $functionsNotWritable}
                                                    {$MGLANG->T('please_set')} {$functionsPath} {$MGLANG->T('directory_as')} {$MGLANG->T('writable')}<br />
                                                {/if}                                                
                                            </li>
                                        </ul>  
                                    {/if}
                                    <div class="col-md-12">
                                        <h3 class="diblock">{$MGLANG->T('registrars')}</h3> 
                                        <span class="btn btn-primary btn-xs btn-inverse select-all">{$MGLANG->T('select_all')}</span>
                                    </div>
                                    <table class="table table-striped">
                                        <tbody>
                                            {foreach from=$domains item="four_domains"}
                                                <tr>
                                                    {foreach from=$four_domains item="domain"}
                                                        <td {if !in_array($domain.extension, $avalibleRegistrarDomains)} class="hidden" {/if}>
                                                            {if $domain}
                                                                <label class="checkbox checkbox-inline"><input type="checkbox" name="registrarDomain[{$domain.id}]" {if in_array($domain.id, $registrarDomains)} checked {/if} /> {$domain.extension}</label>                                                               
                                                            {/if}
                                                        </td>
                                                    {/foreach}
                                                </tr>
                                            {foreachelse}
                                                <tr><td>{$MGLANG->T('there_is_no_domain_configured_yet')}</td></tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
                            </div>                                    
                        </div>
                        <!-- ========================================== NOTIFICATIONS ====================================== -->
                        <div class="tab-pane" id="notifications-tab">
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('client_notifications')}</h3>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs13" class="col-sm-3 control-label">{$MGLANG->T('zone_created')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs13" name="settings[client_notification_zone_created]" {if $package.setting.client_notification_zone_created == 'on'}checked=""{/if}/> 
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs14" class="col-sm-3 control-label">{$MGLANG->T('zone_altered')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs14" name="settings[client_notification_zone_altered]" {if $package.setting.client_notification_zone_altered == 'on'}checked=""{/if}/> 
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs15" class="col-sm-3 control-label">{$MGLANG->T('zone_removed')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs15" name="settings[client_notification_zone_removed]" {if $package.setting.client_notification_zone_removed == 'on'}checked=""{/if}/> 
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <h3>{$MGLANG->T('admin_notifications')}</h3>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="fs16" class="col-sm-3 control-label">{$MGLANG->T('cron_synchronization')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs16" name="settings[admin_notification_cron_synchronizator]" {if $package.setting.admin_notification_cron_synchronizator == 'on'}checked=""{/if}/> 
                                </div>
                            </div>    
                            <div class="form-group">
                                <label for="fs17" class="col-sm-3 control-label">{$MGLANG->T('cron_migrator')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs17" name="settings[admin_notification_cron_migrator]" {if $package.setting.admin_notification_cron_migrator == 'on'}checked=""{/if}/>
                                </div>
                            </div>     
                            <div class="form-group">
                                <label for="fs18" class="col-sm-3 control-label">{$MGLANG->T('cron_cleaner')}</label>
                                <div class="col-sm-9 checkbox">
                                    <input type="checkbox" id="fs18" name="settings[admin_notification_cron_cleaner]" {if $package.setting.admin_notification_cron_cleaner == 'on'}checked=""{/if}/> 
                                </div>
                            </div> 
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('close')}</button>
                {if $edit}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="packageSave">{$MGLANG->T('save_changes')}</button>
                {else}
                    <button type="button" class="btn btn-primary btn-inverse" data-act="packageSave">{$MGLANG->T('add')}</button>
                {/if}
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

{literal}
    <script>
        allowedRegistarTlds = [ {/literal}{foreach from=$domainsWithoutNativeDnsSupport item='tld'}'{$tld}', {/foreach}{literal} ]; 
    </script>
    
    <style type="text/css">
        .diblock {
            display: inline-block;
        }
        .mg-wrapper span.select-all {
            display: inline-block;
            margin-bottom: 4px;
        }
    </style>
    
    <script data-cfasync="false" type="text/javascript">
        (function($) {
            $(document).ready( function() {
                $('.select-all').click(function() {
                    var chBox = $(this).parents('.row').first().find(':checkbox:not(:disabled):not(:checked)');
                    if(chBox.length == 0){
                        $(this).parents('.row').first().find(':checkbox:not(:disabled)').prop('checked', false).iCheck('update');     
                    }else{
                        $(this).parents('.row').first().find(':checkbox:not(:disabled)').prop('checked', true).iCheck('update');  
                        var changedList = $(this).parents('.row').first().find(':checkbox:not(:disabled)');
                        var firstName = changedList.first().prop('name');
                        if(firstName.indexOf('domains') === 0)
                        {
                            $.each( changedList, function(key, value){
                                DNSShowRegistrarTld(value);
                            });
                        }
                    }
                });
                $('.allowedDomain').on('ifToggled', function() {
                    DNSShowRegistrarTld(this);
                });
                DNSStartServerValidation();
                $('#allowedRecordTypes').on('change', $('#allowedRecordTypes'), function(){
                    DNSStartServerValidation();
                });
            });
        })(jQuery);
        function DNSGetValuesToArray(list){
            var valList = [];
            $.each( list, function(key, value){
                valList[key] = $(value).val();
            });
            return valList;
        }
        function DNSStartServerValidation(){
            DNSRemoveServerValidationAllerts();
            DNSRemoveRecordValidationAllerts();
            var recordTypesList = $('#allowedRecordTypes').val();
            var selectedServersList = DNSGetValuesToArray($("input[name='servers[]']"));
            if(selectedServersList.length>0 && recordTypesList!==null){
                DNSValidateServersBySupportedRecords(recordTypesList, selectedServersList);
            }            
        }
        function DNSValidateServersBySupportedRecords(records, servers)
        {
            JSONParser.request(
                'validateServersByRecords',
                [
                    {name: 'recordsTypes', value: records},
                    {name: 'servers', value: servers}                        
                ],
                function(data){
                    var validationContent1 = '';
                    $.each( data, function(key, value){
                        var row = ''; 
                        row += '<li class="list-group-item list-group-item-danger">';
                        row += '{/literal}{$MGLANG->absoluteT('addonAA', 'settings', 'Server')}{literal} ' + value.serverName + 
                            ' {/literal}{$MGLANG->absoluteT('addonAA', 'settings', 'does not support')}{literal} ';
                        if(value.unsuportedRecords.length > 1){
                            row += '{/literal}{$MGLANG->absoluteT('addonAA', 'settings', 'records')}{literal}: ';                            
                        }else{
                            row += '{/literal}{$MGLANG->absoluteT('addonAA', 'settings', 'record')}{literal}: ';
                        }
                        row += value.unsuportedRecords;
                        row += '</li>';
                        var tableRow = '<tr name="DNSServerRecordValidationRow"><td colspan="7" style="padding: 0px 0px 0px 0px;"><ul class="list-group" style="margin-bottom:0px;">';
                        tableRow += row;
                        tableRow += '</ul></td></tr>';
                        validationContent1 += row;
                        DNSAddServerValidationAllert(value.serverId, tableRow);
                    });
                    $('#DNSRecordValidationAlert').html(validationContent1);
                }
            );            
        }
        function DNSAddServerValidationAllert(serverId, dataRow){
            var list = $("input[name='servers[]']");
            $.each( list, function(key, value){
                if($(value).val() == serverId){
                    $(value).parents('tr').after(dataRow);
                }
            });            
        }
        function DNSRemoveServerValidationAllerts(){
            var list = $("tr[name='DNSServerRecordValidationRow']");
            $.each( list, function(key, value){
                $(value).remove();
            });            
        }        
        function DNSRemoveRecordValidationAllerts(){
            $('#DNSRecordValidationAlert').html('');
        }
        function DNSShowRegistrarTld(allowItem)
        {
            var name = jQuery(allowItem).prop('name');
            var newName = name.replace('domains','registrarDomain');
            var domain = name.substring(8, (name.length -1));
            if($.inArray(domain, allowedRegistarTlds) === -1){
                return false;
            } 
            var domainReg = $("input[name='"+newName+"']");
            if($(allowItem).prop('checked')){
                $(domainReg).parent().parent().parent().removeClass('hidden');
            }else{
                $(domainReg).iCheck('uncheck');
                $(domainReg).parent().parent().parent().addClass('hidden');                        
            }            
        }
        
        jQuery('input[name="settings[zone_automation_pending_transfer_domain]"]').change(function(){
            if(this.checked == true)
            {
                jQuery('#si1').show();
            }
            else
            {
                jQuery('#si1').hide();
            }
        });
        
        jQuery('input[name*="settings[allowed_record_types]"]').keyup(function(){
            records = jQuery('input[name*="settings[allowed_record_types]"]');
            limit   = jQuery('input[name="record_limit"]');  
            count = 0;
            records.each(function(key,value){
                if(value.value)
                {
                    count = count+parseInt(value.value);
                } 
            });  
            if(count > limit.val())
            {
                limit.css('border','1px solid red');
            }
            else
            {
                limit.css('border','');
            }
        });
        
        jQuery('button[data-act="packageSave"]').click(function(ev){
            records = jQuery('input[name*="settings[allowed_record_types]"]');
            limit   = jQuery('input[name="record_limit"]');
             name    = jQuery('input[name="name"]');
            count = 0;
            records.each(function(key,value){
                if(value.value)
                {
                    count = count+parseInt(value.value);
                }
            });

            if(count > limit.val())
            {
                $('a[href="#records-tab"]').trigger('click');
                ev.stopPropagation();
                limit.css('border','1px solid red');
            }else if(jQuery('input[name="name"]').val() == ""){
                $('a[href="#general-tab"]').trigger('click');
                ev.stopPropagation();
                jQuery('input[name="name"]').css('border','1px solid red'); 
            }

            if(!name.length)
            {
                console.log('eeerr2');
                ev.stopPropagation();
                name.css('border','1px solid red');                
            }           
        });
    </script>
{/literal}