<div class="module-main-header">
    <a href="index.php?m=DNSManager2&mg-action=editZone&zone_id={$smarty.request.zone_id}" class="btn btn-back btn-icon"><i class="fa fa-arrow-left"></i></a><h2>{$MGLANG->T('dns_manager')}</h2>
</div>

{if !$error}
<div class="module-content">
    <div class="module-header">
        <div class="header-title">
            <h1>{$MGLANG->T('dnssec')} - {$zone_name}</h1>
        </div>
        <div class="header-actions">
            <div class="header-search">
                <div class="row-fluid-xs">
                    <div class="fluid-100">
                    </div>
                    <div class="fluid-0">
                        {if $is_signed}
                            <button class="btn btn-primary" data-act="rectifyDnssec" data-query="zone_id={$zoneid}">{$MGLANG->T('rectify_dnssec')}</button>
                            <button class="btn btn-danger" data-act="disableDnssec" data-query="zone_id={$zoneid}">{$MGLANG->T('disable_dnssec')}</button>
                        {else}
                            <button class="btn btn-primary" data-act="enableDnssec" data-query="zone_id={$zoneid}">{$MGLANG->T('enable_dnssec')}</button>
                        {/if}
                    </div>
                </div>
            </div> 
        </div>
    </div>
    <div class="module-body">
        {if $keys}
            <!-- DNS keys -->
            {if $keys.keys}
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="header-title">
                            <a aria-controls="collapseOne" aria-expanded="true" href="#zone_signing_key"  data-toggle="collapse" class="">
                                <i class="fa fa-angle-down"></i><i class="fa fa-angle-up"></i> {$MGLANG->T('dnssec_keys')}
                            </a>
                        </h4>
                    </div>
                    <div class="panel-collapse collapse in" id="zone_signing_key" style="" aria-expanded="true">
                        <table class="table table-marginless">
                            <thead>
                                <tr>
                                    <th>{$MGLANG->T('key_tag')}</th>
                                    <th>{$MGLANG->T('flags')}</th>
                                    <th>{$MGLANG->T('algorithm')}</th>
                                    <th>{$MGLANG->T('bits')}</th>
                                    <th>{$MGLANG->T('public_key')}</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach from=$keys.keys item=key}
                                    <tr>
                                        <td>{$key->getId()}</td>
                                        <td>{$key->getType()}</td>
                                        <td>{$key->getDnsKey()->getAlgorithmName()}</td>
                                        <td>
                                            {if $key->getBits()}
                                                {$key->getBits()}
                                            {else}
                                                - 
                                            {/if}
                                        </td>
                                        <td><input readonly class="dnssec" type="text" value="{$key->getDnsKey()->getPublicKey()|escape}" /></td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>
                    </div>
                </div>
            {/if}
            <!-- /DNS keys -->
             
            <!-- delegation signer records -->
            {if $keys.ds}
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="header-title">
                            <a aria-controls="collapseOne" aria-expanded="true" href="#delegation_signer_records"  data-toggle="collapse" class="">
                                <i class="fa fa-angle-down"></i><i class="fa fa-angle-up"></i> {$MGLANG->T('delegation_signer_records')}
                            </a>
                        </h4>
                    </div>
                    <div class="panel-collapse collapse in" id="delegation_signer_records" style="" aria-expanded="true">
                        <table class="table table-marginless">
                            <thead>
                                <tr>
                                    <th>{$MGLANG->T('key_tag')}</th>
                                    <th>{$MGLANG->T('algorithm')}</th>
                                    <th>{$MGLANG->T('digest_type')}</th>
                                    <th>{$MGLANG->T('digest')}</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach from=$keys.ds item=key}
                                    <tr>
                                        <td>{$key->getKeytag()}</td>
                                        <td>{$key->getAlgorithmName()}</td>
                                        <td>{$key->getDigestTypeName()}</td>
                                        <td><input readonly class="dnssec" type="text" value="{$key->getDigest()|escape}" /></td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>
                    </div>
                </div>
            {/if}
            <!-- /delegation signer records --> 
        {else}
            {if $is_signed}
                <p class="text-center">{$MGLANG->T('no_dnsseck_keys')}</p>
            {else}
                <p class="text-center">{$MGLANG->T('dnssec_is_disabled')}</p>
            {/if}
        {/if}
    </div>              
</div>
{/if} 