<div class="module-main-header">
    <a href="index.php?m=DNSManager2" class="btn btn-back btn-icon"  style="height: inherit;"><i class="fa fa-arrow-left"></i></a><h2>{$MGLANG->T('dns_manager')}</h2>
</div>
{if !$error}
<div class="module-content">
    <div class="module-header mg-custom-header">
        <div class="header-title">
            <h1>{$MGLANG->T('manage_rdns')}</h1>
        </div>
        <div class="header-actions">
            <div class="header-search">
                <div class="row-fluid-xs">
                    <div class="fluid-100">
                        <div class="input-icon">
                            <input class="form-control searchTable" type="text" placeholder="{$MGLANG->T('search')}" data-search="">
                        </div>
                    </div>
                    <div class="fluid-0">
                        <button class="btn btn-primary" data-act="addRDNS" data-query="">{$MGLANG->T('add_ptr')}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="module-body">
            <div class="row">
            {foreach from=$records_count item="count" key="record"}
                <div class="col-xs-2" style="color: #45464C;"><b>{$record|strtoupper}</b> <span class="badge badge-{if $count > $limits[$record]}danger{else}primary{/if}">{$count} / {if isset($limits[$record])}{$limits[$record]}{else}0{/if}</span></div>
            {/foreach}
            </div>
        <div class="section">
            <table class="table">
                <thead>
                    <tr>
                        <th>{$MGLANG->T('name')}</th>
                        <th>{$MGLANG->T('type')}</th>
                        <th {if $ttl_disabled}style="display: none;"{/if}>{$MGLANG->T('ttl')}</th>
                        <th>{$MGLANG->T('rdata')}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody id="edit-form">
                    <tr class="no-matches" style="display: none;"><td colspan="5" class="text-center">{$MGLANG->T('no_matches_found')}</td></tr>
                    {foreach from=$ptrs item="record"}
                        <tr id="record{$counter}" class="record">
                            <td data-label="{$MGLANG->T('name')}" class="cell-sm-12 form-group">
                                <input type="text" class="form-control" name="record[{$counter}][name]" value="{$record.ip}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','name')}" placeholder="{$MGLANG->T('name')}" required="" disabled=""/>
                            </td>
                            <td data-label="{$MGLANG->T('type')}" class="cell-sm-12">
                                <input type="hidden" name="record[{$counter}][type]" value="PTR"/>
                                <input class="form-control" type="text" value="PTR" disabled="" title="{$MGLANG->absoluteT('addonAA','zones','record_type_info', 'PTR')}"/>
                            </td>
                            <td data-label="{$MGLANG->T('ttl')}" class="cell-sm-12 form-group">
                                <input class="form-control" type="number" name="record[{$counter}][ttl]" value="{$record.ttl}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','ttl')}" placeholder="{$MGLANG->T('ttl')}" required="" min="1" disabled=""/></td>
                            <td data-label="{$MGLANG->T('rdata')}" class="cell-sm-12">
                                <input class="form-control table-input" type="text" name="record[{$counter}][field][ptrdname]" value="{if !empty($record.sub)}{$record.sub}.{/if}{$record.from}" title="{$MGLANG->absoluteT('addonAA','zones','record_field_info','PTR', 'ptrdname')}" placeholder="ptrdname" disabled=""/>
                            </td>
                            <td data-label="{$MGLANG->T('actions')}" class="cell-sm-12 cell-actions">
                                <input name="record[{$counter}][ip]" type="hidden" value="{$record.ip}" />
                                <button type="button" class="btn btn-primary btn-icon" data-act="editRDNS" data-query="rid={$record.id}" title="{$MGLANG->T('edit_record')}">
                                    <i class="fa fa-pencil"></i>
                                </button>
                                <button type="button" class="btn btn-danger btn-icon" data-act="removeRDNS" data-query="rid={$record.id}" data-confirm-body="{$MGLANG->T('remove_zone_record_confirm')}" title="{$MGLANG->T('remove_record')}" >
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        {assign var="counter" value=$counter+1}
                    {foreachelse}
                        <tr class="empty-record"><td colspan="5" align="center">{$MGLANG->T('there_is_no_ptr_record')}</td></tr>
                    {/foreach}
                </tbody>
            </table>
        </div>
    </div>              
</div>
{/if}

{literal}
    <script data-cfasync="false" type="text/javascript">
        (function($){
            $(document).ready(function() {
                $(document).delegate("#edit-form [name^=record]", 'keydown', function() {
                    $(this).parents('tr').find(':input').attr('name', function() {
                        if(this.name.indexOf('edit_') !== 0)
                            return 'edit_' + this.name;
                        return this.name;
                    });
                });

                $(document).delegate("[data-search]", 'keyup', function() {
                    var search = $(this).val().toLowerCase();
                    
                    if(!search.length) {
                        $('#edit-form > tr.record').show().css('display', "");
                        $('.no-matches').css('display', 'none');
                        if($('#edit-form > tr.record').length == 0){
                            $('.empty-record').removeClass('hidden');
                        }
                        return ;
                    }

                    $('#edit-form > tr.record').each(function() {
                        if ($('input', this).filter(function() {return this.value.toLowerCase().indexOf(search) > -1;}).length) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                    $('#edit-form > tr.no-matches').toggle(!$('#edit-form > tr.record:visible').length);
                    
                    if(!$('#edit-form > tr.record:visible').length == true){
                        $('.empty-record').addClass('hidden');
                    }
                    if(!search && $('#edit-form > tr.record').length == 0){
                         $('.empty-record').removeClass('hidden');
                    }
                });
                
            });
        })(jQuery);
    </script>
{/literal}