<div class="modal fade modal-lg" id="edit-set-modal" >
    <div class="modal-dialog" style="width: 800px;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                <h4 class="modal-title">{if $set.edit}{$MGLANG->T('set_edit')}{else}{$MGLANG->T('add_set')}{/if}</h4>

                <ul class="nav nav-tabs text-right" role="tablist">
                    <li class="active"><a href="#general-tab" role="tab" data-toggle="tab">{$MGLANG->T('general')}</a></li>
                    <li><a href="#records-tab" role="tab" data-toggle="tab">{$MGLANG->T('records')}</a></li>              
                </ul>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="set-form">
                    {if $set.edit}<input type="hidden" name="id" value="{$set.id}" />{/if}
                    <div class="tab-content">
                        <!-- ========================================== GENERAL ====================================== -->
                        <div class="tab-pane active" id="general-tab">                        
                            <div class="form-group">
                                <label class="col-sm-2 control-label">{$MGLANG->T('name')}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="name" value="{$set.name}" required pattern="{$patterns.no_white_chars_at_beginning}">
                                </div>
                            </div>
                            <div class="form-group">                        
                                <label for="" class="col-sm-2 control-label"  title="" data-original-title="{$MGLANG->T('default_check_desc')}">{$MGLANG->T('def')}</label>
                                <div class="col-sm-1">
                                    <div class="checkbox" style="padding-top: 7px;" title="" data-original-title="{$MGLANG->T('default_check_desc')}">
                                        <input value="1" name="default" {if $set.default eq "1"}checked="checked"{/if} type="checkbox"/>
                                    </div> 
                                </div>
                            </div>
                        </div>
                        <!-- ========================================== RECORDS ====================================== -->
                        <div class="tab-pane" id="records-tab">                        
                            <div class="row set-records">
                                <div class="alert alert-info info_wiki" role="alert">
                                    {$MGLANG->T('wiki')}
                                </div>
                                <div class="col-md-12" style="overflow-y: auto; max-height: 400px;">
                                    <table class="table table-striped">
                                        <tbody>
                                            {foreach from=$set.records item="record"}
                                                <tr>
                                                    <td><input type="text" class="form-control" name="record[{$counter}][name]" value="{$record->name}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','name')}" placeholder="{$MGLANG->absoluteT('addonAA','zones','name')}"/></td>
                                                    <td><input type="text" class="form-control" disabled="" name="record[{$counter}][type]" value="{$record->type}" title="{$MGLANG->absoluteT('addonAA','zones','record_type_info',$record->type)}"/><input type="hidden" name="record[{$counter}][type]" value="{$record->type}"/></td>
                                                    <td><input type="text" class="form-control" name="record[{$counter}][ttl]" value="{$record->ttl}" title="{$MGLANG->absoluteT('addonAA','zones','record_info','ttl')}" placeholder="{$MGLANG->absoluteT('addonAA','zones','ttl')}"/></td>
                                                    <td>
                                                        {foreach from=$record->rdata key="field" item="value"}
                                                            <input type="text" class="form-control table-input" name="record[{$counter}][field][{$field}]" value="{$value}" placeholder="{$MGLANG->absoluteT('addonCA','zones','record_field_placeholder',$record->type, $field)}" title="{$MGLANG->absoluteT('addonAA','zones','record_field_info',$record->type,$field)}"/>
                                                        {/foreach}
                                                    </td>
                                                    <td>
                                                        <input name="record[{$counter}][id]" type="hidden" value="{$record->id}" />
                                                        <a class="btn btn-danger btn-icon-only" onclick="$(this).parents('div.set-records').first().append('<input type=\'hidden\' name=\'remove_record[]\' value=\'{$record->id}\' />'); removeRecord($(this));" title="{$MGLANG->T('remove')}"><span class="glyphicon glyphicon-remove"></span></a>
                                                    </td>
                                                </tr>
                                                {assign var="counter" value=$counter+1}
                                            {/foreach}
                                            <tr class="nobody-is-here" {if count($set.records)}style="display: none;"{/if}>
                                                <td colspan="5" class="text-center">{$MGLANG->T('there_is_no_record_within_this_set')}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-md-8"></div>
                                <div class="col-md-4">
                                    <div class="row add-me-right-here">
                                        <div class="col-md-9 col-xs-6">
                                            <input type="hidden" name="records_counter" value="{$set.count + 1}" />
                                            <select class="select2" name="new_record_type">
                                            {foreach from=$available_record_types item="record"}
                                                <option value="{$record}">{$record}</option>
                                            {/foreach}
                                            </select>
                                        </div>
                                        <div class="col-md-3 col-xs-3">
                                            <a class="btn btn-success" data-act="addNewRecord" data-do-not-close-the-modal="" data-no-validate="1" title="{$MGLANG->T('add_new_record')}">
                                                <span class="glyphicon glyphicon-plus"></span>
                                            </a>
                                        </div>
                                    </div>
                                </div> 
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('close')}</button>
                {if $set.edit}
                    <button type="button" form="set-form" class="btn btn-primary" data-act="setSave">{$MGLANG->T('save_changes')}</button>
                {else}
                    <button type="button" form="set-form" class="btn btn-primary" data-act="setSave">{$MGLANG->T('add')}</button>
                {/if}
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

{literal}
    <script data-cfasync="false" type="text/javascript">

        $(document).on('click', 'a[href="#records-tab"]', function (e) {

            var input = $('input[name="name"]');
            var inputVal = input.val();
            if(inputVal === '' || inputVal.length === 0)
            {
                $('a[href="#general-tab"]').click();
                var form = $('#set-form');
                form.validator('validate');
            }


        });
    </script>
{/literal}