$(document).ready(function () {
    var lang;
    var operator;
    var sortableIn;
    var timer;

    var phpDiv = ace.edit("phpDiv");
    phpDiv.session.setMode({path: "ace/mode/php", inline: true});

    clearTimeout(timer);
    timer = setTimeout(function () {
        $(".note").fadeOut('slow', function () {
            $(".note").hide();
        });
    }, 7000);
    getLang();

    var draggableOptions = {
        helper: 'clone',
        revert: 'invalid',
        appendTo: 'body',
        start: function (event, ui) {
            var item = ui.helper.context;
            if ($(item).hasClass('tableDraggable')) {
                $('.droppableTable').addClass('activeWell');
            } else {
                $('.droppableField').addClass('activeWell');
            }
        },
        stop: function (event, ui) {
            var item = ui.helper.context;
            if ($(item).hasClass('tableDraggable')) {
                $('.droppableTable').removeClass('activeWell');
            } else {
                $('.droppableField').removeClass('activeWell');
            }
        }
    };

    //drag table element
    var droppableTable = {
        accept: '.draggable',
        drop: function (event, ui) {
            $(this).removeClass("over");
            var contType = getContainerType(this);

            if (contType === 'joinsDiv' && $(ui.draggable).hasClass('used')) {
                alert(lang['label']['table_already_joined']);
                return;
            }

            selectActionTable(this, ui);
        },
        over: function (event, ui) {
            $(this).addClass("over");
        },
        out: function (event, ui) {
            $(this).removeClass("over");
        }
    };
    //drag field
    var droppableField = {
        accept: '.fieldElement',
        drop: function (event, ui) {
            $(this).removeClass("over");
            selectActionField(this, ui);
        },
        over: function (event, ui) {
            $(this).addClass("over");
        },
        out: function (event, ui) {
            $(this).removeClass("over");
        }
    };
    var sortable = {
        start: function (event, ui) {
            if (isCondition(ui.item.prev())) {
                operator = ui.item.prev();
            }
            if (isCondition(ui.item.next().next())) {
                operator = ui.item.next().next();
            }
        },
        change: function (event, ui) {
        },
        update: function (event, ui) {
            if (isCondition(ui.item.next().next())) {
                $(operator).insertAfter(ui.item);
            } else {
                $(operator).insertBefore(ui.item);
            }

            serializeAfterSort(ui.item);
        },
        over: function (e, ui) {
            sortableIn = 1;
        },
        out: function (e, ui) {
            sortableIn = 0;
        },
        beforeStop: function (event, ui) {
//            var newItem = ui.item;
            var contType = getContainerType(ui.item);
            if (sortableIn === 0) {
                deleteElement(ui.item);
            }

            serializeAfterSort(contType);
        }
    };
    refreshDroppableAndDraggable();
    function isCondition(thisObj) {
        if ($(thisObj).hasClass('and') || $(thisObj).hasClass('or')) {
            return true;
        }

        return false;
    }

    function getLang() {
        //initialize bootstrap switch
        $("[name='my-checkbox']").bootstrapSwitch();
        $('#refreshReport').hide();
        getSectionTitleAndDescr();

        JSONParser.request('getLang', {},
                function (data) {
                    lang = data[0];
                    refreshAll();
                });
    }

    function disabledAutoUpdate() {
        var state = $('#auto_update_onoff').bootstrapSwitch('state');

        //on button click always return false 
        if ($('#refreshReport').hasClass('manual')) {
            return false;
        }

        return !state;
    }

    function refreshDroppableAndDraggable() {
        $(".draggable").draggable(draggableOptions);
        $(".droppableTable").droppable(droppableTable);
        $(".fieldElement").draggable(draggableOptions);
        $(".sortable,#joinsDiv").sortable(sortable);
        $(".droppableField").droppable(droppableField);
//        $(".droppableField").droppable("option", "accept", ".fieldElement");
    }

    function serializeAfterSort(contType) {
        if (disabledAutoUpdate()) {
            return;
        }

        switch (contType) {
            case 'COUNT':
            case 'Fields':
            case 'SUBSTR':
            case 'CONCAT':
            case 'SUM':
            case 'MAX':
            case 'MIN':
            case 'AVG':
            case 'SUBSTR':
            case 'fieldsDiv':
            case 'fields':
                serializeFieldsAndSend(true);
                break;
            case 'groupByDiv':
                serializeGroupByAndSend(true);
                break;
            case 'orderByDiv':
                serializeOrderByAndSend(true);
                break;
            case 'whereDiv':
            case 'baseWhere':
                serializeWhereAndSend(true);
                break;
            case 'joinsDiv':
                serializeJoinsAndSend(true);
                break;
            default:
                //if you dont know what to do do everything
                serializeAll();
                break;
        }

        generateReport();
    }

    function serializeAll() {
        serializeFieldsAndSend(true);
        serializeOrderByAndSend(true);
        serializeWhereAndSend(true);
        serializeJoinsAndSend(true);
        serializeOrderByAndSend(true);
    }

    function selectActionTable(thisObj, uiObj) {
        var tableName = $(uiObj.draggable).attr('id');
        var containerType = getContainerType(thisObj);
        switch (containerType) {
            case 'baseDiv':
//                addBaseTable(tableName, thisObj, uiObj.draggable.clone());
                $('#deleteBaseTableModal').attr('data-basetable', tableName);
                if ($('#baseDiv').children().length) {
                    $('#deleteBaseTableModal').modal('show');
                } else {
                    addBaseTable(tableName);
                }

                break;
            case 'addNewJoinDiv':
                prepareModalForJoin(tableName);
                break;
            default :
                break;
        }

        getAllColumns();
    }

    function getSectionTitleAndDescr() {
        JSONParser.request('getSectionTitleAndDescription', {},
                function (data) {
                    $('#title').val(data.title);
                    $('#chartDescr').val(data.descr);
                });
    }

    function selectActionField(thisObj, uiObj) {
        var tableName = $(uiObj.draggable).attr('table');
        var columnName = $(uiObj.draggable).attr('column');
        var containerType = getContainerType(thisObj);
        switch (containerType) {
            case 'baseWhere':
                addWhereCondition(thisObj, tableName, columnName);
                break;
            case 'COUNT':
            case 'CONCAT':
            case 'SUM':
            case 'MAX':
            case 'MIN':
            case 'AVG':
                addSimpleElement(tableName, columnName, thisObj);
                serializeFieldsAndSend();
                break;
            case 'groupByDiv':
                if (!$('#groupByDiv').children().length) {
                    $('#groupByDiv').html('');
                }

                addSimpleElement(tableName, columnName, '#groupByDiv');
                serializeGroupByAndSend();
                break;
            case 'orderByDiv':
//                addSimpleElement(tableName, columnName, '#orderByDiv');
//                serializeGroupByAndSend();
                prepareOrderByModal(tableName, columnName);
                $('#orderByModal').modal('show');
                break;
            case 'fieldsDiv':
                addSimpleElement(tableName, columnName, thisObj);
                serializeFieldsAndSend();
                break;
            case 'fields':
            case 'Fields':
            case 'baseField':
                $('#addFieldModal').find('#tableDropdown').prop('disabled', true);
                addSelectElement(thisObj, tableName, columnName);
                break;
            case 'fieldsNewContainer':
                fieldsNewContainer(thisObj, tableName, columnName);
                break;
            case 'createNewContainer':
                createNewContainer(thisObj, tableName, columnName);
                break;
            default :
                addWhereCondition(thisObj, tableName, columnName);
                break;
        }
    }

    function createNewContainer(thisObj, tableName, columnName) {
        $('#createNewContainer').addClass('currentlyEdited');
        $('#whereModal').find('#tableDropdown').prop('disabled', true);
        prepareWhereModalForValue(tableName, columnName);
        $('#whereModal').modal('show');
    }

    function fieldsNewContainer(thisObj, tableName, columnName) {
        setOptGroupValueSelected('tableDropdown', tableName, columnName, '#fieldsModal');
        $('#fieldsModal').find('#tableDropdown').prop('disabled', true);
        $('#functionCustomFields').hide();
        $('#fieldsModal').find('#containerTypeDropdown').val('Fields');
        $('#fieldsModal').find('#fieldsAlias').val(columnName.substr(0, 1).toUpperCase() + columnName.substr(1));
        $('#fieldsModal').modal('show');
    }

    function addSelectElement(thisObj, tableName, columnName, alias) {
        setOptGroupValueSelected('tableDropdown', tableName, columnName, '#addFieldModal');
        $(thisObj).addClass('currentlyEdited');
        var column = $('#addFieldModal').find('#tableDropdown option:selected').attr('data-colname');
        if (alias) {
            $('#addFieldModal').find('#alias').val(alias);
        } else {
            $('#addFieldModal').find('#alias').val(column.substr(0, 1).toUpperCase() + column.substr(1));
        }

        $('#addFieldModal').modal('show');
    }

    function addSimpleElement(tableName, columnName, div) {
        var data = {
            tablename: tableName,
            columnname: columnName
        };
        var text = getTableName(tableName) + ': ' + columnName;
        var html = getSimpleElement(text, data, text, 'ui-widget-content ui-draggable ui-draggable-handle field');
        $(div).append(html);
    }

    function addWhereCondition(thisObj, tableName, columnName) {
        setOptGroupValueSelected('tableDropdown', tableName, columnName);
        $('#tableDropdown').prop('disabled', true);
        prepareWhereModalForValue();
        $(thisObj).addClass('currentlyEdited');
        $('#whereModal').modal('show');
    }

    function setOptGroupValueSelected(divID, table, column, thisObj) {
        if (thisObj) {
            $(thisObj).find('#' + divID + ' option[value="' + table + '.' + column + '"]').prop('selected', true);
        } else {
            $('#' + divID + ' option[value="' + table + '.' + column + '"]').prop('selected', true);
        }
    }

    function prepareWhereModalForFilter() {
        var data = getAllAtributes($('.currentlyEdited'));
        if (data.conditionInput) {
            $('#whereModal').find('#conditionInput').val(data.conditionInput);
        }

        $('#conditionTypeDropdown').val('filter');
        $('#customValues').hide();
        $('#conditionDropdown').hide();
        $('#whereModal').find('#filterTitle').val('');
        $('#whereModal').find('#filterDescr').val('');
        $('#whereModal').find('#dropdownFilterValues').val('');
        if ($('.currentlyEdited').hasClass('dropped')) {
            var data = getAllAtributes($('.currentlyEdited'));
            $('#whereModal').find('#filterTypeDropdown').val(data.filterType);
            $('#whereModal').find('#filterTitle').val(data.filterTitle);
            $('#whereModal').find('#filterDescr').val(data.filterDescr);
            if (data.filterType === 'DropdownFilter') {
                $('#dropdownFilterValuesDiv').show();
            } else {
                $('#dropdownFilterValuesDiv').hide();
            }

            if (data.filterOptions) {
                $('#whereModal').find('#dropdownFilterValues').val(data.filterOptions);
            }

            setOptGroupValueSelected('tableDropdown', data.tableName, data.columnName, '#whereModal');
        } else {
            $('#filterTypeDropdown').val('DateRangeFilter');
        }

        $('#filterDiv').show();
    }

    function prepareWhereModalForValue(tableName, columnName) {
        $('#whereModal').find('#conditionInput').val('');
        if (tableName && columnName) {
            setOptGroupValueSelected('tableDropdown', tableName, columnName, '#whereModal');
        }

        $('#conditionTypeDropdown').val('value');
        $('#filterDiv').hide();
        $('#dropdownFilterValuesDiv').hide();
        $('#conditionDropdown').show();
        $('#customValues').show();
        $('#conditionField').hide();
        $('#conditionValue').show();
        if ($('.currentlyEdited').hasClass('dropped')) {
            var data = getAllAtributes($('.currentlyEdited'));
//        if (data.conditionInput) {
            setOptGroupValueSelected('tableDropdown', data.tableName, data.columnName, '#whereModal');
            $('#whereModal').find('#conditionType').val(data.conditionType).change();

            if (data.conditionInput) {
                $('#whereModal').find('#conditionInput').val(data.conditionInput).change();
            } else {
                $('#whereModal').find('#conditionInputFrom').val(data.conditioninputfrom).change();
                $('#whereModal').find('#conditionInputTo').val(data.conditioninputto).change();
            }
        }
    }

    function prepareWhereModalForField() {
        $('#conditionTypeDropdown').val('field');
        $('#conditionDropdown').show();
        $('#customValues').show();
        $('#filterDiv').hide();
        $('#dropdownFilterValuesDiv').hide();
        $('#conditionValue').hide();
        $('#conditionField').show();
        if ($('.currentlyEdited').hasClass('dropped')) {
            var data = getAllAtributes($('.currentlyEdited'));
            $('#editFieldsModal').find('#alias').val(data.aliasname);
            $('#whereModal').find('#conditionType').val(data.conditionType);
            setOptGroupValueSelected('tableDropdown', data.tableName, data.columnName, '#whereModal');
            setOptGroupValueSelected('fieldsDropdown', data.conditionTable, data.conditionColumn, '#whereModal');
        }
    }

    function getAllColumns() {
        JSONParser.request('getAllTables', {
            exceptTable: '', //get all tables, without exceptions 
            fieldsUsage: true
        },
                function (data) {
                    var field = '';
                    var dropdown = '';
//                    var dropdown = '<select id="fieldsDropdown" class="form-control">';
                    $.each(data.tblCols, function (table, value) {
                        field += '<div class="well well-sm">';
                        field += '<div class="ui-widget-content contType">' + getTableName(table) + '</div>';
                        dropdown += '<optgroup label="' + table + '">';
                        $.each(value, function (column, used) {
                            $('#tablesDiv').find('#' + table).addClass('used');
                            field += '<div class="ui-widget-content fieldElement ui-draggable ui-draggable-handle" \n\
                                table="' + table + '" \n\
                                column="' + column + '">' + column + '</div>';
                            dropdown += '<option data-tableName="' + table + '" data-colName="' + column + '" value="' + table + '.' + column + '">' + column + '</option>';
                        });
                        field += '</div>';
                        dropdown += '</optgroup>';
                    });

                    $('.toJoin').removeClass('toJoin');
                    $.each(data.availableToJoin, function (index, table) {
                        $('#allTablesDiv').find('#' + table).addClass('toJoin');
                    });

                    dropdown += '</select>';
                    $('.tableDropdownDiv').html('<select id="tableDropdown" class="form-control">' + dropdown);
                    $('#fieldsDropdownDiv').html('<select id="fieldsDropdown" class="form-control">' + dropdown);
                    $('#allColumnsDiv').html(field);
                    $(".fieldElement").draggable(draggableOptions);
                });
    }

    function getContainerType(thisObj) {
        if ($(thisObj).find('.contType').text()) {
            return $.trim($(thisObj).find('.contType').attr('data-conttype'));
        }

        var ids = [
            'fieldsNewContainer',
            'createNewContainer',
            'joinsDiv',
            'addNewJoinDiv',
            'groupByDiv',
            'baseDiv',
            'baseField',
            'orderByDiv',
            'groupByDiv',
            'orderByDiv',
            'baseWhere'];
        if (jQuery.inArray($(thisObj).attr('id'), ids) !== -1) {
            return $(thisObj).attr('id');
        }

        if ($(thisObj).parent().attr('id') && !$(thisObj).parent().hasClass('dropped')) {
            return $.trim($(thisObj).parent().attr('id'));
        }

        if ($(thisObj).parent().parent().attr('id')) {
            return $.trim($(thisObj).parent().parent().attr('id'));
        }

        return '';
    }

    function prepareModalForJoin(tableName) {
        var join = getDataFromJoinElement();
        tableColumnsDropdown(tableName, 'allTableColumnsDropdown', join.table, join.column);
        addAllTablesColumnsDropdown('', 'tableColumnsDropdown', join.joinedtable, join.joinedcolumn);

        if (join.jointypename) {
            $('#joinType').val(join.jointypename.replace(' ', '_'));
        }

        $('#joinsModal').modal('show');
    }

    function tableColumnsDropdown(tableName, targetClass, selectedTable, selectedColumn) {
        JSONParser.request('getTableColumns', {
            tableName: tableName
        },
                function (data) {
                    var dropdown = '<select id="tableColumns" table="' + tableName + '" class="form-control">';
                    $.each(data, function (index, value) {
                        dropdown += '<optgroup label="' + index + '">';
                        $.each(value, function (value2, index2) {
                            dropdown += '<option data-tableName="' + index + '" data-columnName="' + value2 + '" value="' + index + '.' + value2 + '">' + value2 + '</option>';
                        });
                        dropdown += '</optgroup>';
                    });
                    dropdown += '</select>';
                    $('.' + targetClass).html(dropdown);

                    if (selectedTable && selectedColumn) {
                        setOptGroupValueSelected('tableColumns', selectedTable, selectedColumn);
                    }
                });
    }

    function addAllTablesColumnsDropdown(exceptTable, targetClass, table, column) {

        JSONParser.request('getAllTablesWithColumns', {
            exceptTable: exceptTable
        },
                function (data) {
                    if (data.length === 0) {
                        return;
                    }

                    var dropdown = '<select id="allTablesDropdown" class="form-control">';
                    $.each(data, function (tablename, value) {
                        dropdown += '<optgroup label="' + tablename + '">';
                        $.each(value, function (columnname, index2) {
                            dropdown += '<option data-tablename="' + tablename + '" data-columnname="' + columnname + '" value="' + tablename + '.' + columnname + '">' + columnname + '</option>';
                        });
                        dropdown += '</optgroup>';
                    });
                    dropdown += '</select>';
                    $('.' + targetClass).html(dropdown);

                    if (table && column) {
                        setOptGroupValueSelected('allTablesDropdown', table, column);
                    }
                    return;
                });
    }

    function prepareJoinsModal(joinResponse) {
        generateJoinDropdown(joinResponse);
        $('#joinsModal').modal('show');
    }

    function generateJoinDropdown(joinResponse) {
        var dropdown = '<select id="joinsDropdown" class="form-control">';
        $.each(joinResponse, function (i, join) {
            dropdown += returnDropdownOption(join);
        });
        dropdown += '</select>';
        $('#joinToTable').html(dropdown);
    }

    function returnDropdownOption(data) {
        var string = '';
        var text = '';
        if (jQuery.type(data.column) === "string") {
            string += '<option ';
            text = 'JOIN ' + getTableName(data.joinedtable) + ' TO ' + getTableName(data.table);
            var dataAttrs = returnDataAttrsAsString(data);
            if (data.description) {
                text += ' - ' + data.description;
            }
            string += dataAttrs + 'value = "' + data.joinedtable + '" > ' + text + ' </option>';
        } else {
            $.each(data.column, function (key, value) {
                string += '<option ';
                text = 'JOIN ' + getTableName(data.joinedtable) + ' TO ' + getTableName(data.table);
                if (data.description[key]) {
                    text += ' - ' + data.description[key];
                }

                string += returnDataAttrsAsStringFromArrays(data, key) + 'value = "' + data.joinedtable + '" > ' + text + ' </option>';
            });
        }

        return string;
    }

    function returnDataAttrsAsString(data) {
        var string = '';
        $.each(data, function (id, value) {
            string += 'data-' + id + '="' + value + '" ';
        });
        return string;
    }

    function returnDataAttrsAsStringFromArrays(data, id) {
        var string = '';
        string += 'data-jointype="' + data.jointype + '"';
        string += ' data-joinedtable="' + data.joinedtable + '"';
        string += ' data-joinedcolumn="' + data.joinedcolumn[id] + '"';
        string += ' data-table="' + data.table + '"';
        string += ' data-column="' + data.column[id] + '"';
        return string;
    }

    function getTableName(tableName) {
        if (lang['whmcs_table'][tableName]) {
            tableName = lang['whmcs_table'][tableName];
        }
        return tableName;
    }

    function editJoinedTable(join) {
        var ce = $('.currentlyEdited');
        var joinedTableName = getTableName(join.joinedtable);
        var tableName = getTableName(join.table);

        var text = join.jointypename + ' ' + joinedTableName + ' ON ' + joinedTableName + ': ' + join.joinedcolumn + ' = ' + tableName + ': ' + join.column;
        $(ce).attr('data-jointype', join.jointypenem);
        $(ce).attr('data-firsttablename', join.table);
        $(ce).attr('data-firstcolumnname', join.column);
        $(ce).attr('data-joinedtablename', join.joinedtable);
        $(ce).attr('data-joinedcolumnname', join.joinedcolumn);
        $(ce).html(text);
        $('#tablesDiv').find('#' + join.joinedtable).addClass('used'); //mark table as used on table list
//        $('#joinsDiv').append(html);
    }

    function addJoinedTable(join) {
        var joinedTableName = getTableName(join.joinedtable);
        var tableName = getTableName(join.table);

        var html = '<div style="display: block; text-align: center;" data-jointype="' + join.jointypename + '" ';
        html += 'data-firsttablename="' + join.table + '" ';
        html += 'data-firstcolumnname="' + join.column + '" ';
        html += 'data-joinedtablename="' + join.joinedtable + '" ';
        html += 'data-joinedcolumnname="' + join.joinedcolumn + '" ';
        html += 'class="ui-widget-content ui-draggable ui-draggable-handle dropped"> ';
        html += join.jointypename + ' ' + joinedTableName + ' ON ' + joinedTableName + ': ' + join.joinedcolumn + ' = ' + tableName + ': ' + join.column;
        html += '</div>';
        $('#tablesDiv').find('#' + join.joinedtable).addClass('used'); //mark table as used on table list

        $('#joinsDiv').append(html);
        serializeJoinsAndSend();
    }

    function addBaseTable(tableName) {
        var parsedName = getTableName(tableName);

        var html = getSimpleElement(parsedName, {}, tableName, 'ui-widget-content dropped');
        $('#baseDiv').html(html);
        JSONParser.request('addBaseTable', {
            baseTable: tableName
        },
                function (data) {
                    refreshAll();
                    generateReport();
                });

        showPanels();
    }

    function showPanels() {
        $('.panel-primary').show();
        $('.panel-body').show();
    }

    function getValueElementData() {
        var tableName = $("#tableDropdown option:selected").attr('data-tablename');
        var columnName = $("#tableDropdown option:selected").attr('data-colname');
        var conditionType = $("#conditionType option:selected").val();
        var data = {
            tablename: tableName,
            columnname: columnName,
            conditiontype: conditionType,
        };

        if (data.conditiontype === 'between') {
            data['conditioninputfrom'] = $('#conditionInputFrom').val();
            data['conditioninputto'] = $('#conditionInputTo').val();
        } else {
            data['conditioninput'] = $('#conditionInput').val();
        }

        return data;
    }

    function getValueElement() {
        var data = getValueElementData();
        var input = '';

        if (data.conditiontype === 'between') {
            input = 'From ' + data.conditioninputfrom + ' To ' + data.conditioninputto;
        } else {
            input = data.conditioninput;
        }

        var text = getTableName(data.tablename) + ': ' + data.columnname + ' ' + ucfirst(data.conditiontype) + ' "' + input + '"';
        return getSimpleElement(text, data, data.tablename, false);
    }

    function getFieldElementData() {
        var tableName = $("#tableDropdown option:selected").attr('data-tablename');
        var columnName = $("#tableDropdown option:selected").attr('data-colname');
        var conditionType = $("#conditionType option:selected").val();
        var conditionTable = $("#fieldsDropdown option:selected").attr('data-tablename');
        var conditionColumn = $("#fieldsDropdown option:selected").attr('data-colname');
        var data = {
            tablename: tableName,
            columnname: columnName,
            conditiontype: conditionType,
            conditiontable: conditionTable,
            conditioncolumn: conditionColumn
        };
        return data;
    }

    function getFieldElement() {
        var data = getFieldElementData();
        var text = getTableName(data.tablename) + ': ' + data.columnname + ' ' + data.conditiontype + ' ' + getTableName(data.conditiontable) + ': ' + data.conditioncolumn;
        return getSimpleElement(text, data, data.tablename, false);
    }

    function getFilterElementData() {
        var tableName = $("#tableDropdown option:selected").attr('data-tablename');
        var columnName = $("#tableDropdown option:selected").attr('data-colname');
        var filterType = $("#filterTypeDropdown option:selected").val();
        var filterTypeText = $("#filterTypeDropdown option:selected").text();
        var filterTitle = $("#filterTitle").val();
        var filterDescr = $("#filterDescr").val();
        var filterName = makeID();
        var data = {
            tablename: tableName,
            columnname: columnName,
            filtertype: filterType,
            filtertitle: filterTitle,
            filtername: filterName,
            filterdescr: filterDescr
        };
        var dropdownFilterValues = $("#dropdownFilterValues").val();
        if (dropdownFilterValues) {
            data['filterOptions'] = dropdownFilterValues;
        }

        return {
            data: data,
            filterTypeText: filterTypeText
        };
    }

    function getFilterElement() {
        var d = getFilterElementData();
        var data = d.data;
        var filterTypeText = d.filterTypeText;
        var text = filterTypeText + ' (' + getTableName(data.tablename) + ': ' + data.columnname + ')';
        return getSimpleElement(text, data, data.tablename, 'ui-widget-content ui-draggable ui-draggable-handle dropped filter');
    }

    function getNewContainer() {
        return '<div class="well well-sm droppableField ui-droppable currentlyEdited sortable"></div>';
    }

    function addOperatorDiv(obj) {
        return '<div class="ui-widget-content ' + obj.toLowerCase() + '">' + obj + '</div>';
    }

    function addFilterDiv(obj, targetDiv) {

        var filter = obj.filter.FilterType;
        var table = obj.table.Field[0];
        var column = obj.table.Field[1];
        var title = filter.filterTitle;
        var name = filter.filterName;
        var type = filter.filterType;
        var descr = filter.filterDescr;
        var options = '';
        if (filter.filterOptionsString) {
            options = 'data-filterOptions="' + filter.filterOptionsString + '"';
        }

        var html = '<div id="tblhosting" class="ui-widget-content ui-draggable ui-draggable-handle dropped filter" \n\
                        data-tablename="' + table + '" \n\
                        data-columnname="' + column + '" \n\
                        data-filtertype="' + type + '" \n\
                        data-filtertitle="' + title + '" \n\
                        data-filtername="' + name + '" \n\
                        ' + options + ' \n\
                        data-filterdescr="' + descr + '">' + type + '(' + getTableName(table) + ': ' + column + ')\n\
                    </div>';
        $(targetDiv).append(html);
    }

    function addContainerDiv(obj) {
        var targetDiv = $('#whereDiv');
        $('.targetDiv').removeClass('targetDiv');
        if (obj) {
            targetDiv.append(addOperatorDiv(obj));
        }

        targetDiv.append('<div class="well well-sm droppableField ui-droppable sortable targetDiv sortable"></div>');
        refreshDroppableAndDraggable();
    }

    function getContainerTitleElement(text, data) {
        var html = '<div ';
        html += 'class="ui-widget-content contType" ';
        $.each(data, function (attrName, attrValue) {
            html += 'data-' + attrName + '="' + attrValue + '" ';
        });
        html += '>' + text + '</div>';
        return html;
    }

    function getSimpleElement(text, data, id, classes) {
        var html = '<div ';
        if (id) {
            html += 'id="' + id + '" ';
        }

        html += 'class="ui-widget-content ui-draggable ui-draggable-handle dropped ';
        if (classes) {
            html += classes;
        }
        html += '"';

        $.each(data, function (attrName, attrValue) {
            html += 'data-' + attrName + '="' + attrValue + '" ';
        });
        html += '>' + text + '</div>';
        return html;
    }

    function editSimpleElement(thisObj, text, data, id) {
        $(thisObj).removeData();
        if (id) {
            $(thisObj).attr('id', id);
        }

        $(thisObj).removeData();
        $.each(data, function (attrName, attrValue) {
            $(thisObj).attr('data-' + attrName, attrValue);
        });
        $(thisObj).html(text);
    }

    function getOperator() {
        return '<div class="ui-widget-content and">AND</div>';
    }

    function serializeFieldsAndSend(doNotGenerateReport) {
        if (disabledAutoUpdate()) {
            return;
        }

        var containers = $('#fieldsDiv').children();
        var fields = new Array();
        var temp = new Array();
        $(containers).each(function () {
            $(this).children().each(function () {
                temp.push(getAllAtributes(this));
            });
            fields.push(temp);
            temp = new Array();
        });

        JSONParser.request('addColumnsToSession',
                {fields: fields},
                function (data) {
                    if (!doNotGenerateReport) {//if true do not generate report
                        generateReport();
                    }
                });
    }

    function getAllAtributes(thisObj) {
        var attributes = ['tableName', 'columnName', 'conditionType',
            'conditionInput', 'conditionTable', 'conditionColumn',
            'aliasname', 'alias', 'conttype', 'jointype', 'firsttablename',
            'firstcolumnname', 'joinedtablename', 'joinedcolumnname', 'secondcolumnname',
            'substrlength', 'substrstart', 'filterType', 'filterTitle', 'filterName',
            'filterDescr', 'filterOptions', 'direction', 'conditioninputfrom', 'conditioninputto'];
        var attrs = {};
        $(attributes).each(function (element) {
            if ($(thisObj).attr('data-' + attributes[element])) { //cant use .data() because it is cached by jQuery
                attrs[$.trim(attributes[element])] = $.trim($(thisObj).attr('data-' + attributes[element]));
            } else if ($(thisObj).data(attributes[element])) {
                attrs[attributes[element]] = $.trim($(thisObj).data(attributes[element]));
            }
        });
        return attrs;
    }

    function serializeWhereAndSend(doNotGenerateReport) {
        if (disabledAutoUpdate()) {
            return;
        }

        var containers = $('#whereDiv').children();
        var where = new Array();
        $(containers).each(function () {
            if ($(this).hasClass('droppableField')) { //if div is container
                $(this).children().each(function () {
                    if ($(this).hasClass('and') || $(this).hasClass('or')) { //if is operator between conditions
                        where.push({operator: $(this).text()});
                    } else {
                        where.push(getAllAtributes(this));
                    }
                });
            } else {
                if ($(this).hasClass('and') || $(this).hasClass('or')) { //if is operator between containers
                    where.push({containerOperator: $(this).text()});
                }
            }
        });
        JSONParser.request('addWhereToSession', {
            where: where
        },
                function (data) {
                    if (!doNotGenerateReport) { //if true do not generate report
                        generateReport();
                    }
                });
    }

    function serializeJoinsAndSend(doNotGenerateReport) {
        if (disabledAutoUpdate()) {
            return;
        }

        var containers = $('#joinsDiv').children();
        var joins = new Array();
        $(containers).each(function () {
            if ($(this).hasClass('dropped')) { //if div is container
                joins.push(getAllAtributes(this));
            }
        });
        JSONParser.request('joinTable', {
            joins: joins
        },
                function (data) {
                    getAllColumns();
//                    getJoins();

                    $('.toJoin').removeClass('.toJoin');
                    $.each(data, function (index, table) {
                        $('#allTablesDiv').find('#' + table).addClass('toJoin');
                    });

                    if (!doNotGenerateReport) { //if true do not generate report
                        generateReport();
                    }
                });
    }

    function serializeGroupByAndSend(doNotGenerateReport) {
        if (disabledAutoUpdate()) {
            return;
        }

        var containers = $('#groupByDiv').children();
        var groupByFields = new Array();
        $(containers).each(function () {
            if ($(this).hasClass('dropped')) { //if div is container
                groupByFields.push(getAllAtributes(this));
            }
        });
        JSONParser.request('addGroupByToSession', {
            groupBy: groupByFields
        },
                function (data) {
//                    getAllColumns();
                    if (!doNotGenerateReport) { //if true do not generate report
                        generateReport();
                    }
                });
    }

    function serializeOrderByAndSend(doNotGenerateReport) {
        if (disabledAutoUpdate()) {
            return;
        }

        var containers = $('#orderByDiv').children();
        var orderByFields = new Array();
        $(containers).each(function () {
            if ($(this).hasClass('dropped')) { //if div is container
                orderByFields.push(getAllAtributes(this));
            }
        });
        JSONParser.request('addOrderByToSession', {
            orderBy: orderByFields
        },
                function (data) {
                    if (!doNotGenerateReport) { //if true do not generate report
                        generateReport();
                    }
                });
    }

    function getJoins() {
        var targetDiv = $('#joinsDiv');
//        targetDiv.html('');
        JSONParser.request('getJoinedTables', {},
                function (data) {
                    $.each(data, function (return1, r) {
                        $('#joinsDiv').show();
                        var text = r.joinType + ' ' + getTableName(r.joinedTableName) + ' ON ' + getTableName(r.firstTableName) + ': ' + r.firstColumnName + ' = ' + getTableName(r.joinedTableName) + ': ' + r.joinedColumnName;
                        targetDiv.append('<div style="display: block; text-align: center;" \n\
                            data-joinType="' + r.joinType + '"\n\
                            data-firstTableName="' + r.firstTableName + '"\n\
                            data-firstColumnName="' + r.firstColumnName + '"\n\
                            data-joinedTableName="' + r.joinedTableName + '"\n\
                            data-joinedColumnName="' + r.joinedColumnName + '"\n\
                            class="ui-widget-content ui-draggable ui-draggable-handle dropped">' + text + '</div>');
                    });
                });
    }

    function getWhere() {
        $('#whereDiv').addClass('targetDiv');
        JSONParser.request('getWhereConditions', {},
                function (data) {
                    if ($('.targetDiv').length < 2 && data.length) { //if no container div create one
                        addContainerDiv(false);
                    }
                    var targetDiv = $('.targetDiv');
                    $.each(data, function (return1, r) {
                        if (r.Filter) {
                            addFilterDiv(r.Filter, targetDiv);
                        }

                        if (r.Where) {
                            addWhereDiv(r.Where, targetDiv);
                        }

                        if (r.Operator) {
                            targetDiv.append(addOperatorDiv(r.Operator));
                        }

                        if (r.ContainerOperator) {
                            addContainerDiv(r.ContainerOperator);
                            targetDiv = $('.targetDiv');
                            $('.targetDiv').removeClass('targetDiv');
                        }
                    });
                });
        $('.targetDiv').removeClass('targetDiv');
    }

//    function addWhereDiv(obj, targetDiv) {
//        var text = getTableName(obj[0].Field[0]) + ': ' + obj[0].Field[1] + ' ' + obj[1].Condition;
//        var tableName = obj[0].Field[0];
//        var columnName = obj[0].Field[1];
//        var conditionType = obj[1].Condition;
//        if (obj[2].Field) {
//            text += ' ' + getTableName(obj[2].Field[0]) + ': ' + obj[2].Field[1];
//        } else {
//            if (obj[2].String === null) {
//                obj[2].String = '';
//            }
//
//            text += ' "' + obj[2].String + '"';
//        }
//
//        var html = '<div id="' + obj[0].Field[0] + '" class="ui-widget-content ui-draggable ui-draggable-handle dropped editDiv sortable">' + text + '</div>';
//        targetDiv.append(html);
//        var div = $('.editDiv');
//        div.data('tableName', tableName);
//        div.data('columnName', columnName);
//        div.data('conditionType', conditionType);
//        if (obj[2].Field) {
//            div.data('conditionTable', obj[2].Field[0]);
//            div.data('conditionColumn', obj[2].Field[1]);
//        } else {
//            div.data('conditionInput', obj[2].String);
//        }
//
//        $('.editDiv').removeClass('editDiv');
//    }
    function addWhereDiv(obj, targetDiv) {
        var data = {
            tableName: obj[0].Field[0],
            columnName: obj[0].Field[1],
            conditionType: obj[1].Condition
        };

        var text = getTableName(obj[0].Field[0]) + ': ' + obj[0].Field[1] + ' ' + obj[1].Condition;
        if (obj[2].Field) {
            text += ' ' + getTableName(obj[2].Field[0]) + ': ' + obj[2].Field[1];
        } else if (obj[2].BetweenValues) {
            var from = obj[2].BetweenValues.from;
            var to = obj[2].BetweenValues.to;

            data['conditioninputfrom'] = from;
            data['conditioninputto'] = to;

            text += ' ' + from + ' and ' + to;
        } else if (obj[2].Expression) {
            var exp = obj[2].Expression.replace("(", "").replace(")", "");
            data['conditioninput'] = exp;
            text += ' "' + exp + '"';
        }
        else {
            if (obj[2].Text === null) {
                obj[2].Text = '';
            }

            text += ' "' + obj[2].Text + '"';
        }

        var html = getSimpleElement(text, data, obj[0].Field[0], 'editDiv sortable');
        targetDiv.append(html);
        $('.editDiv').removeClass('editDiv');
    }

    function getOrderBy() {
        JSONParser.request('getOrderBy', {},
                function (data) {
                    var targetDiv = $('#orderByDiv');
                    if (!$('#orderByDiv').children().length && data.length) { //if empty clear description
                        $('#orderByDiv').html('');
                    }

                    $.each(data, function (return1, r) {
                        var tableName = r.Field[0];
                        var columnName = r.Field[1];
                        var direction = r.OrderDirection;
                        var directionText = 'Ascending';
                        if (direction === 'DESC') {
                            directionText = 'Descending';
                        }

                        var id = tableName + '.' + columnName;
                        var text = getTableName(tableName) + ': ' + columnName + ' Direction: ' + directionText;
                        var data = {
                            tablename: r.Field[0],
                            columnname: r.Field[1],
                            direction: r.OrderDirection
                        };
                        var html = getSimpleElement(text, data, id, 'ui-widget-content ui-draggable ui-draggable-handle dropped');
                        $(targetDiv).append(html);
                    });
                });
    }
    
    function getPhpCode() {
        JSONParser.request('getPhpCode', {},
                function (data) {
                    if (!data.phpCode) {
                        phpDiv.setReadOnly(true);
                    } else if(data.phpCode){
                      $('#usePHP').prop('checked', true);
                        phpDiv.setValue(data.phpCode); 
                      $('#usePHP').change();
                    }
                });
    }    

    function getGroupBy() {
        JSONParser.request('getGroupBy', {},
                function (data) {
                    var targetDiv = $('#groupByDiv');
                    if (!$('#groupByDiv').children().length && data.length) { //if empty clear description
                        $('#groupByDiv').html('');
                    }

                    $.each(data, function (return1, r) {
                        var field = r.Field[0] + '.' + r.Field[1];
                        var tableName = r.Field[0];
                        var columnName = r.Field[1];
                        //todo przerobić na getsimpleelement
                        targetDiv.append('<div id="' + field + '" class="ui-widget-content ui-draggable ui-draggable-handle dropped"\n\
                            data-columnName=' + columnName + '\n\
                            data-tablename=' + tableName + '>\n\
                            ' + getTableName(r.Field[0]) + ': ' + r.Field[1] + '</div>');
                    });
                });
    }

    function getFields() {
        JSONParser.request('getFields', {},
                function (data) {
                    var targetDiv = $('#fieldsDiv');
                    $('#targetDiv').html('');
                    $.each(data, function (return1, r) {
                        //select container
                        if (r.Select) {
                            targetDiv = $('#fieldsDiv');
                            var html = '<div class="well well-sm droppableField sortable">';
                            html += '<div class="ui-widget-content contType ui-sortable-handle" data-conttype="Fields">Fields</div>';
                            $.each(r.Select, function (return1, r2) {
                                var tableName = r2.Field[0];
                                var columnName = r2.Field[1];
                                var text = getTableName(tableName) + ': ' + columnName;
                                var alias = '';
                                if (r2.Alias) {
                                    alias = 'data-aliasname="' + r2.Alias + '"';
                                    text += ' AS ' + r2.Alias;
                                }

                                html += '<div class="ui-widget-content ui-draggable sortable ui-draggable-handle dropped" ' + alias + ' data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + text + '</div>';
                            });
                            html += '</div>';
                            targetDiv.append(html);
                        }

                        //fields container
                        if (r.Field) {
                            targetDiv = $('#fieldsDiv');
                            var html = '<div class="well well-sm droppableField sortable">';
                            html += '<div class="ui-widget-content contType ui-sortable-handle" data-conttype="Fields">Fields</div>';
                            var tableName = r.Field[0];
                            var columnName = r.Field[1];
                            var text = getTableName(tableName) + ': ' + columnName;

                            var alias = '';
                            if (r.Field[2]) {
                                alias = 'data-aliasname="' + r.Field[2] + '"';
                                text += ' AS ' + r.Field[2];
                            }

                            html += '<div class="ui-widget-content ui-draggable sortable ui-draggable-handle dropped" ' + alias + ' data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + text + '</div></div>';
                            targetDiv.append(html);
                        }

                        targetDiv = $('#fieldsDiv');
                        //sum container
                        if (r.Sum) {
                            var tableName = r.Sum[0].Field[0];
                            var columnName = r.Sum[0].Field[1];
                            var text = 'SUM ';
                            var data = 'data-conttype="SUM"';
                            if (r.Sum[1].Alias) {
                                text += ' AS ' + r.Sum[1].Alias;
                                data += ' data-aliasname="' + r.Sum[1].Alias + '"';
                            }

                            targetDiv.append('<div class="well well-sm sortable ui-droppable"><div class="ui-widget-content contType" ' + data + '>' + text + '</div><div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div></div>');
                        }

                        //count container
                        if (r.Count) {
                            var tableName = r.Count[0].Field[0];
                            var columnName = r.Count[0].Field[1];
                            var text = 'COUNT ';
                            var data = 'data-conttype="COUNT"';
                            if (r.Count[1].Alias) {
                                text += ' AS ' + r.Count[1].Alias;
                                data += ' data-aliasname="' + r.Count[1].Alias + '"';
                            }

                            targetDiv.append('<div class="well well-sm sortable ui-droppable">\n\
                                        <div class="ui-widget-content contType" ' + data + '>' + text + '</div>\n\
                                        <div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div></div>');
                        }

                        //max container
                        if (r.Max) {
                            var tableName = r.Max[0].Field[0];
                            var columnName = r.Max[0].Field[1];
                            var text = 'MAX ';
                            var data = 'data-conttype="MAX"';
                            if (r.Max[1].Alias) {
                                text += ' AS ' + r.Max[1].Alias;
                                data += ' data-aliasname="' + r.Max[1].Alias + '"';
                            }

                            targetDiv.append('<div class="well well-sm sortable ui-droppable"><div class="ui-widget-content contType" ' + data + '>' + text + '</div><div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div></div>');
                        }

                        //min container
                        if (r.Min) {
                            var tableName = r.Min[0].Field[0];
                            var columnName = r.Min[0].Field[1];
                            var text = 'MIN ';
                            var data = 'data-conttype="MIN"';
                            if (r.Min[1].Alias) {
                                text += ' AS ' + r.Min[1].Alias;
                                data += ' data-aliasname="' + r.Min[1].Alias + '"';
                            }

                            targetDiv.append('<div class="well well-sm sortable ui-droppable"><div class="ui-widget-content contType" ' + data + '>' + text + '</div><div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div></div>');
                        }

                        //avg container
                        if (r.Avg) {
                            var tableName = r.Avg[0].Field[0];
                            var columnName = r.Avg[0].Field[1];
                            var text = 'AVG ';
                            var data = 'data-conttype="AVG"';
                            if (r.Avg[1].Alias) {
                                text += ' AS ' + r.Avg[1].Alias;
                                data += ' data-aliasname="' + r.Avg[1].Alias + '"';
                            }

                            targetDiv.append('<div class="well well-sm sortable ui-droppable"><div class="ui-widget-content contType" ' + data + '>' + text + '</div><div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div></div>');
                        }

                        //substr container
                        if (r.Substr) {
                            var text = 'SUBSTR ';
                            var data = 'data-conttype="SUBSTR"';
                            if (r.Substr[3].Alias) {
                                text += ' AS ' + r.Substr[3].Alias;
                                data += ' data-aliasname="' + r.Substr[3].Alias + '"';
                            }

                            var tableName = r.Substr[0].Field[0];
                            var columnName = r.Substr[0].Field[1];
                            var start = r.Substr[1].Value;
                            var length = r.Substr[2].Value;
                            targetDiv.append('<div class="well well-sm ui-droppable sortable">\n\
                                                <div class="ui-widget-content contType" ' + data + '>' + text + '</div>\n\
                                                <div id="substrField" class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">Field: ' + getTableName(tableName) + ': ' + columnName + '</div>    \n\
                                                <div id="substrStart" class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-substrstart="' + start + '">Start: ' + start + '</div>\n\
                                                <div id="substrLength" class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-substrlength="' + length + '">Length: ' + length + '</div>\n\
                                            </div>');
                        }

                        //concat container
                        if (r.Concat) {
                            targetDiv.append('<div class="well well-sm droppableField ui-droppable editDiv sortable"><div class="ui-widget-content contType" data-conttype="CONCAT">CONCAT</div></div>');
                            targetDiv = $('.editDiv');
                            $.each(r.Concat, function (return1, r2) {
                                if (r2.Field) {
                                    var tableName = r2.Field[0];
                                    var columnName = r2.Field[1];
                                    targetDiv.append('<div class="ui-widget-content ui-draggable ui-draggable-handle dropped" data-columnname="' + columnName + '" data-tablename="' + tableName + '">' + getTableName(tableName) + ': ' + columnName + '</div>');
                                } else if (r2.Alias) {
                                    $('.editDiv').find('.contType').attr('data-aliasname', r2.Alias);
                                    $('.editDiv').find('.contType').html('CONCAT AS ' + r2.Alias);
                                }
                            });
                            $('.editDiv').removeClass('editDiv');
                        }
                    });
                    refreshDroppableAndDraggable();
                });
    }

    function editElement(thisObj) {
        var data = getAllAtributes(thisObj);
        prepareWhereModal(getWhereObjectType(data, thisObj));
    }

    function prepareOrderByModal(tableName, columnName) {
        if ($('.currentlyEdited').hasClass('dropped')) {
            var ce = $('.currentlyEdited');
            var data = getAllAtributes(ce);
            tableName = data.tableName;
            columnName = data.columnName;
            $('#orderByDirection').val(data.direction);
        }

        setOptGroupValueSelected('tableDropdown', tableName, columnName, '#orderByModal');
    }

    function prepareWhereModal(conditionType) {
        switch (conditionType) {
            case 'field':
                prepareWhereModalForField();
                $('#whereModal').modal('show');
                break;
            case 'value':
                prepareWhereModalForValue();
                $('#whereModal').modal('show');
                break;
            case 'filter':
                prepareWhereModalForFilter();
                $('#whereModal').modal('show');
                break;
            case 'SUBSTR':
                prepareSubstrModal();
                $('#substrModal').modal('show');
                break;
            default:
                //todo dodac concata maxa mina i wszystkie inne kurwie to bedzie z groupbaja 
                break;
        }
    }

    function prepareContainerModal(alias) {
        $('#containerModal').find('#containerAlias').val(alias);
    }

    function prepareSubstrModal() {
        var container = $('.currentlyEdited').parent();
        var fieldData = getAllAtributes($(container).find('#substrField'));
        var startObj = $(container).find('#substrStart');
        var lengthObj = $(container).find('#substrLength');
        var titleObj = $(container).find('.contType');
        $('#substrModal').find('#startInput').val($(startObj).attr('data-substrstart'));
        $('#substrModal').find('#lengthInput').val($(lengthObj).attr('data-substrlength'));
        $('#substrModal').find('#substrAlias').val($(titleObj).attr('data-aliasname'));
        setOptGroupValueSelected('tableDropdown', fieldData.tableName, fieldData.columnName, '#substrModal');
    }

    function editElementsData(thisObj) {
        var conditionType = $('#conditionTypeDropdown option:selected').val();
        var data = '';
        var text = '';
        switch (conditionType) {
            case 'field':
                data = getFieldElementData();
                text = getTableName(data.tablename) + ': ' + data.columnname + ' ' + data.conditiontype + ' ' + getTableName(data.conditiontable) + ': ' + data.conditioncolumn;
                break;

            case 'value':
                data = getValueElementData();
                var input = '';
                if (data.conditioninput) {
                    input = '"' + data.conditioninput + '"';
                } else {
                    input = data.conditioninputfrom + ' and ' + data.conditioninputto;
                }

                text = getTableName(data.tablename) + ': ' + data.columnname + ' ' + data.conditiontype + ' ' + input;
                break;

            case 'filter':
                var d = getFilterElementData();
                data = d.data;
                var filterTypeText = d.filterTypeText;
                text = filterTypeText + ' (' + getTableName(data.tablename) + ': ' + data.columnname + ')';
                break;
            default:
                break;
        }

        editSimpleElement(thisObj, text, data, data.tablename);
    }

    function deleteElement(thisObj) {
        var divType = getContainerType($(thisObj).parent());
        var tableName = $(thisObj).attr('id');
        var parentToRemove = thisObj.parent();
        switch (divType) {
            case 'SUBSTR':
                parentToRemove.remove(); //delete whole container if any of substr elements are removed
                serializeFieldsAndSend();
                break;
            case 'orderByDiv':
                thisObj.remove();
                serializeOrderByAndSend();
                break;
            case 'groupByDiv':
                thisObj.remove();
                serializeGroupByAndSend();
                break;
            case 'baseField':
                thisObj.remove();
                serializeOrderByAndSend();
                break;
            case 'joinsDiv':
                var joinedTable = thisObj.data('joinedtablename');
                $('#tablesDiv').find('#' + joinedTable).removeClass('used');
                thisObj.remove();
                if ($('#joinsDiv').children().length === 1) {
                    $('#joinsDiv').hide();
                }

                serializeJoinsAndSend();
                break;
            case 'fields':
                thisObj.remove();
                if (parentToRemove.children().length <= 2) {
                    parentToRemove.remove();
                }

                break;
            case 'baseWhere':
            case 'whereDiv':
                if (isCondition(thisObj.prev())) {
                    thisObj.prev().remove();
                } else if (isCondition(thisObj.next().next())) {
                    thisObj.next().next().remove();
                }

                thisObj.remove();
                if (deleteContainer(parentToRemove)) { //if container should be deleted
                    if (isCondition(parentToRemove.prev())) { //if container has AND or OR operator 
                        parentToRemove.prev().remove(); //delete also container operator before container
                    } else if (isCondition(parentToRemove.next())) {
                        parentToRemove.next().remove();
                    }

                    parentToRemove.remove(); //delete container
                }

                serializeWhereAndSend();
                break;
            case 'Fields':
            case 'COUNT':
            case 'CONCAT':
            case 'SUM':
            case 'MAX':
            case 'MIN':
            case 'AVG':
            case 'fieldsDiv':

                if ($(thisObj).hasClass('contType')) {
                    $(thisObj).parent().remove();
                } else {
                    $(thisObj).remove();
                }

                serializeFieldsAndSend();
                break;
            default:
                break;
        }

        if (deleteContainer(parentToRemove)) {
            parentToRemove.remove();
        }
    }

//return true if container should be deleted
    function deleteContainer(thisObj) {
        var type = getContainerType(thisObj);
        var staticContainers = ['groupByDiv', 'baseField', 'joinsDiv', 'orderByDiv']; //do not delete this containers 'baseWhere',

        if (jQuery.inArray(type, staticContainers) !== -1) {
            return false; //not fond container, free to delete
        }

        var count = $(thisObj).children().length;
        count -= 1; //length return one element more than it is there acctually

        count -= $(thisObj).find('.contType').length; //if there is container title ignore it in count

        if (count > 0) {
            return false;
        }

        return true;
    }

    function toggleRefreshButton(state) {
        if (state) {
            $('#refreshReport').hide();
        } else {
            $('#refreshReport').show();
        }
    }

    function editElementEvent(thisObj) {
        $(thisObj).addClass('currentlyEdited');
        var contType = getContainerType($(thisObj).parent());
        var data = getAllAtributes(thisObj);
        switch (contType) {
            case 'COUNT':
            case 'CONCAT':
            case 'SUM':
            case 'MAX':
            case 'MIN':
            case 'AVG':
            case 'groupByDiv':
                $('#editFieldsModal').find('#editFieldsAliasDiv').hide();
                setOptGroupValueSelected('tableDropdown', data.tableName, data.columnName, '#editFieldsModal');
                $('#editFieldsModal').modal('show');
                break;
            case 'baseDiv':
                break;
            case 'Fields':
                $('#editFieldsModal').find('#editFieldsAliasDiv').show();
                setOptGroupValueSelected('tableDropdown', data.tableName, data.columnName, '#editFieldsModal');
                prepareWhereModalForField(thisObj);
                $('#editFieldsModal').modal('show');
                break;
            case 'whereDiv':
                $('#whereModal').find('#tableDropdown').prop('disabled', false);
                prepareWhereModal(getWhereObjectType(data));
                $('#whereModal').modal('show');
                break;
            case 'baseField':
                $('#addFieldModal').find('#tableDropdown').prop('disabled', false);
                addSelectElement(thisObj, data.tableName, data.columnName, data.aliasname);
                break;
            case 'SUBSTR':
                prepareSubstrModal();
                $('#substrModal').modal('show');
                break;
            case 'orderByDiv':
                prepareOrderByModal();
                $('#orderByModal').modal('show');
                break;
            case 'joinsDiv':
                prepareModalForJoin(data.joinedtablename);
                break;
            default:
//                $('#fieldsDropdown').prop('disabled', false);
                editElement($(thisObj).parent());
                break;
        }
    }

    function hideElementsByName(parentDiv, text, elementsClass) {
        text = text.toLowerCase();

        $(parentDiv).each(function () {
            if (!$(this).hasClass(elementsClass)) {
                return; //if not table element continue
            }

            var id = '';
            if ($(this).attr('id')) {
                id = $(this).attr('id');
            }

            var fName = $(this).text().toLowerCase();
            if (id.toLowerCase().indexOf(text) >= 0 || fName.indexOf(text) >= 0) {
                $(this).show();
            } else {
                $(this).hide();
            }

        });
    }

    function setAlerts(error, mainError) {
//        if (error.length === 0) {
//            return;
//        }
//        var target = $(".mg-error-container");
        var target = $("#mg-error-container");
//        if (mainError) {
//            target = $("#mg-error-container");
//        }

        var textObj = target.find('#text');
        $(textObj).html(error);
        window.scrollTo(0, 0);
        target.show();
        setTimeout(function () {
            target.fadeOut('slow', function () {
                target.hide();
            });
        }, 10000);
    }

    function getWhereObjectType(data, thisObj) {
        var containerType = $(thisObj).find('.contType').attr('data-conttype');
        if (containerType && containerType.length) {
            return containerType;
        }

        if (data.conditionTable) {
            return 'field';
        }

        if (data.filterType) {
            return 'filter';
        }

        return 'value'; //default value
    }

    function refreshAll() {
        refreshData(generateReport);
        $('.currentlyEdited').removeClass('currentlyEdited');
    }
    
    function refreshData(callback){
        getAllColumns();
        getJoins();
        getFields();
        getWhere();
        getGroupBy();
        getOrderBy();
        getPhpCode();
        callback();
    }
    
    function generateReport() {
        var limit = $('#limit:input').val();
        var offset = $('#offset:input').val();
        var title = $('#title').val();
        var descr = $('#chartDescr').val();
        var phpCode = phpDiv.getValue();
        var usePHP = $('#usePHP').is(':checked');
        JSONParser.request('showChart', {
            limit: limit,
            offset: offset,
            title: title,
            descr: descr,
            phpCode: phpCode,
            usePHP: usePHP
        },
                function (data) {
                    if (data.results) {
                        jQuery("#results").html(data.results);
                        jQuery("#results").show();
                    }

                    if (data.report) {
                        jQuery("#report").html(data.report);
                        jQuery("#report").show();
                    }

                    if (data.err) {
                        setAlerts(data.err);
                    }
                });
    }

    function getDataFromJoinElement() {
        var data = {
            jointypename: $('.currentlyEdited').attr('data-jointype'),
            joinedtable: $('.currentlyEdited').attr('data-joinedtablename'),
            joinedcolumn: $('.currentlyEdited').attr('data-joinedcolumnname'),
            table: $('.currentlyEdited').attr('data-firsttablename'),
            column: $('.currentlyEdited').attr('data-firstcolumnname')
        };

        return  data;
    }

    function getDataFromJoinModal() {
        var data = {
            jointypename: $('#joinType option:selected').text(),
            joinedtable: $('#secondColumnName option:selected').attr('data-tablename'),
            joinedcolumn: $('#secondColumnName option:selected').attr('data-columnname'),
            table: $('#allTablesDropdown option:selected').attr('data-tablename'),
            column: $('#allTablesDropdown option:selected').attr('data-columnname'),
        };

        return  data;
    }

    function editSubstrContainer(data) {
        var container = $('.currentlyEdited').parent();
        var classes = 'ui-widget-content ui-draggable ui-draggable-handle dropped';
        var titleHtml = getContainerTitleElement('SUBSTR AS ' + data.alias, {conttype: 'SUBSTR', aliasname: data.alias});
        var fieldHtml = getSimpleElement('Field: ' + getTableName(data.tablename) + ': ' + data.colname, {tablename: data.tablename, columnname: data.colname}, 'substrField', classes);
        var startHtml = getSimpleElement('Start: ' + data.start, {substrstart: data.start}, 'substrStart', classes);
        var lengthHtml = getSimpleElement('Length: ' + data.length, {substrlength: data.length}, 'substrLength', classes);
        $(container).html('');
        $(container).append(titleHtml);
        $(container).append(fieldHtml);
        $(container).append(startHtml);
        $(container).append(lengthHtml);
        serializeFieldsAndSend();
    }

    function getSubstrModalValues() {
        var modal = $('#substrModal');
        var data = {
            tablename: $(modal).find('#tableDropdown option:selected').attr('data-tablename'),
            colname: $(modal).find('#tableDropdown option:selected').attr('data-colname'),
            start: $(modal).find('#startInput').val(),
            length: $(modal).find('#lengthInput').val(),
            alias: $(modal).find('#substrAlias').val()
        };
        return data;
    }

    function makeID() {
        var text = "";
        var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (var i = 0; i < 7; i++)
            text += possible.charAt(Math.floor(Math.random() * possible.length));
        return text;
    }

    $(document).delegate('#usePHP', 'change', function (e) {

        if ($(this).is(":checked")) {
            phpDiv.setReadOnly(false);
        } else {
            phpDiv.setReadOnly(true);
        }

        if ($('#auto_update_onoff').bootstrapSwitch('state')) {
            generateReport();
        }
    });

    $(document).delegate("#saveReport", "click", function () {
        JSONParser.request('getReportTitleAndDescr', {},
                function (data) {
                    $('#reportTitle').val(data.title);
                    $('#reportDescription').val(data.descr);
                });
        $('#saveReportModal').modal('show');
    });
    $(document).delegate('#saveReportModalButton', 'click', function () {
        $('#saveReportModal').modal('hide');
        var reportData = {
            sectionName: makeID(),
            reportName: makeID(),
            sectionTitle: $('#title').val(),
            sectionDescr: $('#chartDescr').val(),
            reportTitle: $('#reportTitle').val(),
            reportDescr: $('#reportDescription').val(),
            limit: $('#limit').val(),
            offset: $('#offset').val(),
            phpCode: ''
        };
        
        if ($('#usePHP').is(':checked')) {
            reportData['phpCode'] = phpDiv.getValue();
        }        
        
        if (reportData['reportTitle'] === 'undefined') {
            reportData['reportTitle'] = 'TestTitle';
        }

        JSONParser.request('saveReportToFile', reportData,
                function (data) {
                    if (data.error) {
                        setAlerts(data.error, true);
                    } else {
                        location.replace('addonmodules.php?module=reportgenerator&mg-page=start&mg-action=viewCustom&report=' + data['reportName']);
                    }
                });
    });
    $('body').on('click', '.and', function (event) {
        $(event.target).html('OR').removeClass('and').addClass('or');
        serializeWhereAndSend();
    });
    $('body').on('click', '.or', function (event) {
        $(event.target).html('AND').removeClass('or').addClass('and');
        serializeWhereAndSend();
    });
    $('body').on('change', '#containerTypeDropdown', function (event) {
        var funcType = $('#containerTypeDropdown option:selected').text();
        switch (funcType) {
            case 'SUBSTR':
                $('#aliasDiv').show();
                $('#functionCustomFields').show();
                break;
//            case 'Fields':
//                $('#functionCustomFields').hide();
//                $('#aliasDiv').hide();
//                break;
            default :
                $('#aliasDiv').show();
                $('#functionCustomFields').hide();
                break;
        }
    });
    $("#containerModalSaveButton").click(function () {
        var alias = $('#containerModal').find('#containerAlias').val();
        var contType = $('.currentlyEdited').attr('data-conttype');
        $('.currentlyEdited').attr('data-aliasname', alias);
        $('.currentlyEdited').html(contType + ' AS ' + alias);
        $('#containerModal').modal('hide');
        serializeFieldsAndSend();
    });
    //todo ##fields new container SAVE##
    $("#joinModalSaveButton").click(function () {
//        joinsModal
        var data = getDataFromJoinModal();

        if ($('.currentlyEdited').hasClass('dropped')) {
            editJoinedTable(data);
        } else {
            addJoinedTable(data);
        }

        $('#joinsDiv').show();

        serializeJoinsAndSend();
        $('#joinsModal').modal('hide');
    });
    //todo ##fields new container SAVE##
    $("#substrModalSaveButton").click(function () {
        var data = getSubstrModalValues();
        editSubstrContainer(data);
        $('#substrModal').modal('hide');
    });
    //todo ##fields new container SAVE##    
    $("#fieldsModalSaveButton").click(function () {
        var tableName = $('#fieldsModal').find("#tableDropdown option:selected").attr('data-tablename');
        var columnName = $('#fieldsModal').find("#tableDropdown option:selected").attr('data-colname');
        var alias = $('#fieldsModal').find('#fieldsAlias').val();
        var funcType = $('#containerTypeDropdown option:selected').text();
        var text = getTableName(tableName) + ':' + columnName;
        var titleText = funcType;
        var titleData = {
            conttype: funcType
//            aliasname: alias
        };
        if (funcType !== 'Fields') {
            titleText += ' AS ' + alias;
            titleData['aliasname'] = alias; //
        }

        var html = '';
        if (funcType === 'Fields' || funcType === 'CONCAT') {
            html = '<div class="well well-sm droppableField sortable">';
        } else {
            html = '<div class="well well-sm sortable">';
        }

        html += getContainerTitleElement(titleText, titleData);
        var data = {
            tablename: tableName,
            columnname: columnName
        };
        if (funcType === 'Fields') {
            data['aliasname'] = alias;
            text += ' AS ' + alias;
        }

        if (funcType === 'SUBSTR') {
            var start = $('#startInput').val();
            var length = $('#lengthInput').val();
            html += getSimpleElement('Field: ' + text, data, 'substrField', 'ui-widget-content ui-draggable ui-draggable-handle field');
            html += getSimpleElement('Start: ' + start, {substrstart: start}, 'substrStart', 'ui-widget-content ui-draggable ui-draggable-handle field');
            html += getSimpleElement('Length: ' + length, {substrlength: length}, 'substrLength', 'ui-widget-content ui-draggable ui-draggable-handle field');
        } else {
            html += getSimpleElement(text, data, '', 'ui-widget-content ui-draggable ui-draggable-handle field');
        }

        html += '</html>';
        $('#fieldsDiv').append(html);
        refreshDroppableAndDraggable();
        serializeFieldsAndSend();
        $('#fieldsModal').modal('hide');
    });
    $("#orderByModalSaveButton").click(function () {
        var modal = $('#orderByModal');
        var tableName = $(modal).find('#tableDropdown option:selected').attr('data-tablename');
        var columnName = $(modal).find('#tableDropdown option:selected').attr('data-colname');
        var direction = $(modal).find('#orderByDirection option:selected').val();
        var directionText = $(modal).find('#orderByDirection option:selected').text();
        var id = tableName + '.' + columnName;
        var text = getTableName(tableName) + ': ' + columnName + ' Direction: ' + directionText;
        var data = {
            tablename: tableName,
            columnname: columnName,
            direction: direction
        };
        if (($('.currentlyEdited').hasClass('dropped'))) {
            editSimpleElement($('.currentlyEdited'), text, data, id);
        } else {
            var html = getSimpleElement(text, data, id, 'ui-widget-content ui-draggable ui-draggable-handle dropped');
            if (!$('#orderByDiv').children().length) {
                $('#orderByDiv').html('');
            }

            $('#orderByDiv').append(html);
        }

        serializeOrderByAndSend();
        $('#orderByModal').modal('hide');
    });
    //todo ##field SAVE##
    $("#addFieldModalSaveButton").click(function () {
        var tableName = $('#addFieldModal').find("#tableDropdown option:selected").attr('data-tablename');
        var columnName = $('#addFieldModal').find("#tableDropdown option:selected").attr('data-colname');
        var alias = $('#alias').val();
        var data = {
            tablename: tableName,
            columnname: columnName,
            aliasname: alias
        };
        var text = getTableName(tableName) + ': ' + columnName + ' AS ' + alias;
        var html = getSimpleElement(text, data, tableName, 'ui-widget-content ui-draggable ui-draggable-handle field');
        if ($('.currentlyEdited').hasClass('dropped')) {
            editSimpleElement($('.currentlyEdited'), text, data, data.tablename);
        } else {
            $('.currentlyEdited').append(html);
        }

        serializeFieldsAndSend();
        $('#addFieldModal').modal('hide');
    });
    $("#editFieldsModalSaveButton").click(function () {
        var table = $('#editFieldsModal').find('#tableDropdown option:selected').attr('data-tablename');
        var column = $('#editFieldsModal').find('#tableDropdown option:selected').attr('data-colname');
        var text = getTableName(table) + ': ' + column;
        var data = {
            columnname: column,
            tablename: table
        };
        if ($('#editFieldsModal').find('#editFieldsAliasDiv').is(":visible")) {
            var alias = $('#editFieldsModal').find('#alias').val();
            data['aliasname'] = alias;
            text += ' AS ' + alias;
        }

        editSimpleElement($('.currentlyEdited'), text, data, text);
        serializeFieldsAndSend();
        serializeGroupByAndSend();
        refreshDroppableAndDraggable();
        $('#editFieldsModal').modal('hide');
    });
    $("#deleteBaseTableModalButton").click(function () {
        var baseTable = $('#deleteBaseTableModal').attr('data-basetable');
        JSONParser.request('addBaseTable', {
            baseTable: baseTable
        },
                function (data) {
                    location.reload();
                });
    });

    $("#resetModalButton").click(function () {
        JSONParser.request('resetSession', {},
                function (data) {
                    location.reload();
                });
    });

    //todo ##WHERE SAVE##
    $("#whereModalSaveButton").click(function () {
        var conditionType = $('#conditionTypeDropdown option:selected').val();
        var html = '';
        switch (conditionType) {
            case 'field':
                html = getFieldElement();
                break;
            case 'value':
                html = getValueElement();
                break;
            case 'filter':
                html = getFilterElement();
                break;
            default:
                break;
        }

        if (getContainerType($('.currentlyEdited')) === 'createNewContainer') {
            if ($('#whereDiv').children().length > 0) {
                $('#whereDiv').append(getOperator());
            }

            $('.currentlyEdited').removeClass('currentlyEdited'); //delete class from newcontainer box

            $('#whereDiv').append(getNewContainer());
            refreshDroppableAndDraggable();
        }

        if ($('.currentlyEdited').hasClass('dropped')) {
            editElementsData($('.currentlyEdited'));
        } else {
            var numberOfChildren = $('.currentlyEdited').children().length;
            if (numberOfChildren) {
                $('.currentlyEdited').append(getOperator());
            }

            $('.currentlyEdited').append(html);
        }

        serializeWhereAndSend();
        $('#whereModal').modal('hide');
    });

    $("#cancelDelete").click(function () {
        $('#deleteBaseTableModal').modal('hide');
    });

    //TODO contType MOUSEDOWN
    $('body').on('mousedown', '.contType', function (e) {
        if (e.which !== 3) { //if not right click, do nothing
            return;
        }

        $(this).addClass('currentlyEdited');
        if ($(this).attr('data-aliasname')) {
            prepareContainerModal($(this).attr('data-aliasname'));
            $('#containerModal').modal('show');
        }
    });

    $('#MGLoader').on('contextmenu', function () {
        return false;
    });

    //add classes which shouldnt have context menu
    $('.dropped').on('contextmenu', function () {
        return false;
    });

    $('body').on('contextmenu', '.dropped', function (e) {
        editElementEvent(this);
        e.preventDefault();
    });
    var timer;

    $("#limit,#offset,#title,#chartDescr,#phpDiv").on('keyup', function () {
        if (disabledAutoUpdate()) {
            return;
        }

        clearTimeout(timer);
        timer = setTimeout(function () {
            generateReport();
        }, 2000); //2 seconds interval
    });

    $('body').on('change', '#conditionTypeDropdown', function (event) {
        var conditionType = $('#conditionTypeDropdown option:selected').val();
        prepareWhereModal(conditionType);
    });

    $('body').on('change', '#filterTypeDropdown', function (event) {
        var filterTypeDropdown = $('#filterTypeDropdown option:selected').val();
        if (filterTypeDropdown === 'DropdownFilter') {
            $('#dropdownFilterValuesDiv').show();
        } else {
            $('#dropdownFilterValuesDiv').hide();
        }
    });

    $('body').on('hidden.bs.modal', function (e) {
        $('.currentlyEdited').removeClass('currentlyEdited'); //delete class on every modal hide
//        serializeWhereAndSend();
    });

    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

    $('body').on('change', '#conditionType', function (event) {
        var conditionType = $('#conditionType option:selected').val();
        if (conditionType === 'between') {
            $('#standardCondition').hide();
            $('#doubleCondition').show();
        } else {
            $('#doubleCondition').hide();
            $('#standardCondition').show();
        }
    });

    $("#searchTables").on('keyup', function () {
        var text = $("#searchTables").val();
        var tableDiv = $('#allTablesDiv').children();
        hideElementsByName(tableDiv, text, 'draggable');
    });

    $("#searchFields").on('keyup', function () {
        var text = $("#searchFields").val();
        var fieldsDiv = $('#allColumnsDiv').find('.well').children();
        hideElementsByName(fieldsDiv, text, 'fieldElement');
    });

    $('#auto_update_onoff').on('switchChange.bootstrapSwitch', function (event, state) {
        var state = $('#auto_update_onoff').bootstrapSwitch('state');
        if (state) {
            serializeAll();
            generateReport();
        }
        toggleRefreshButton(state);
    });

    $('body').on('click', '#refreshReport', function (event) {
        $('#refreshReport').addClass('manual');
        serializeAll();
        generateReport();
        $('.manual').removeClass('manual');
    });

});
