$(document).ready(function () {
    hideMonits();

    $(".deleteButton").click(function () {
        var reportName = $(this).attr('data-reportname');
        $('#deleteReportModal').attr('data-reportname', reportName);
        $('#deleteReportModal').modal('show');
    });

    $('#deleteReportButton').click(function () {
        var reportName = $('#deleteReportModal').attr('data-reportname');
        JSONParser.request('deleteReport',
                {reportName: reportName},
                function (data) {
                    if (data.error) {
                        setAlerts(data.error);
                    } else {
                        location.replace('addonmodules.php?module=reportgenerator&mg-page=start');
                    }
                });
    });

    function setAlerts(error) {
//        if (error.length === 0) {
//            return;
//        }
//
//        var target = $("#mg-error-container");
//        var textObj = target.find('#text');
//        
//        $(textObj).html(error);
//        window.scrollTo(0, 0);
//        target.show();
        setTimeout(function () {
            target.fadeOut('slow', function () {
                target.hide();
            });
        }, 15000);
    }

    $(".editSectionButton").click(function () {
        var sectionName = $(this).data('sectionname');

        console.log(this);
        console.log(sectionName);

//        var sectionName = $(this).data('sectionname');
        $('#addNewSectionModal').data('sectionname', sectionName);
        $('#editSectionModal').modal('show');
    });

    $('#editSection').click(function () {
        var sectionName = $('#addNewSectionModal').data('sectionname');
        var reportName = $('#addNewSectionModal').data('reportname');
        JSONParser.request('editSection', {
            sectionName: sectionName,
            reportName: reportName},
                function (data) {
                    location.replace('addonmodules.php?module=reportgenerator&mg-page=createNewReport');
                });
    });

    $(".addNewSection").click(function () {
        var reportName = $(this).data('reportname');
        $('#addNewSectionModal').data('reportname', reportName);
        $('#addNewSectionModal').modal('show');
    });

    $("#addNewSectionModalButton").click(function () {
        var reportName = $('#addNewSectionModal').data('reportname');

        JSONParser.request('addNewSection', {
            reportName: reportName
        },
                function (data) {
                    location.replace('addonmodules.php?module=reportgenerator&mg-page=createNewReport');
                });
    });

    $("#deleteSectionModalButton").click(function () {
        var sectionName = $('#deleteSectionModal').data('sectionname');
        var reportName = $('.deleteButton').data('reportname');

        JSONParser.request('deleteSection', {
            sectionName: sectionName,
            reportName: reportName
        },
                function (data) {
                    location.reload();
                });
    });

    $('.deleteSectionButton').click(function () {
        var reportType = $(this).data('sectionname');
        $('#deleteSectionModal').data('sectionname', reportType);

        $('#deleteSectionModal').modal('show');
    });

    $('#cancelDeleteSection').click(function () {
        $('#deleteSectionModal').modal('hide');
    });

    $('#cancelDelete').click(function () {
        $('#deleteReportModal').modal('hide');
    });

    $("#cancelAdd").click(function () {
        $('#addNewSectionModal').modal('hide');
    });

    $('#cancelEditSection').click(function () {
        $('#editSectionModal').modal('hide');
    });

    $('.hideEdit').click(function () {
        $('#titleAndDescrDiv').show();
        $('#editTitleAndDescrDiv').hide();
    });

    $('.editReportTitle').click(function () {
        var reportName = $(this).data('reportname');
        var reportTitle = $('#editTitle').val();
        var reportDescr = $('#editDescr').val();

        JSONParser.request('editReportName', {
            reportName: reportName,
            reportTitle: reportTitle,
            reportDescr: reportDescr
        },
                function (data) {
                    if (data.error) {
                        $('#titleAndDescrDiv').show();
                        $('#editTitleAndDescrDiv').hide();

                        setAlerts(data.error);
                        return;
                    }

                    $('#titleAndDescrDiv').find('h3').text(data.title); //title
                    $('#titleAndDescrDiv').find('h5').text(data.descr); //description

                    $('#titleAndDescrDiv').show();
                    $('#editTitleAndDescrDiv').hide();

                });
    });

//    $('body').on('over', '#titleAndDescrDiv', function (event) {
//    });

    //bold title and description on mouseover
    $(document).on('mouseenter', '#titleAndDescrDiv', function () {
        $('#titleAndDescrDiv').find('h3,h5').css("font-weight", "Bold");
    }).on('mouseleave', '#titleAndDescrDiv', function () {
        $('#titleAndDescrDiv').find('h3,h5').css("font-weight", "Normal");
    });

    $(document).on('click', '#titleAndDescrDiv', function () {
        $('#titleAndDescrDiv').hide();
        $('#editTitleAndDescrDiv').show();
    });

    var timer;
    function hideMonits() {
        clearTimeout(timer);

        timer = setTimeout(function () {
            $(".note").fadeOut('slow', function () {
                $(".note").hide();
            });
        }, 7000);
    }

});

