<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Configuration class for Blesta
 * @desc		This grabs configuration settings from Blesta for the Dunamis Framework
 * @package		Dunamis
 * @subpackage	Blesta
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class BlestaDunConfig extends DunObject
{
	/**
	 * Constructor method
	 * @access		public
	 * @version		1.4.4
	 * 
	 * @since		1.3.0
	 */
	public function __construct( $options = array() )
	{
		if (! isset( $options['database'] ) )	$options['database'] = true;
		
		if ( $options['database'] ) {
			$this->load();
		}
	}
	
	
	/**
	 * Getter method
	 * @access		public
	 * @version		1.4.4
	 * @param		string		- $item: the setting being sought
	 * 
	 * @return		mixed value of setting or false
	 * @since		1.3.0
	 */
	public function get( $item )
	{
		$item	=	Configure :: get( 'Dunamis.' . $item );
		
		if ( $item != null ) {
			return $item;
		}
		
		else return false;
	}
	
	
	/**
	 * Singleton
	 * @access		public
	 * @static
	 * @version		1.4.4
	 * @param		array		- $options: contains an array of arguments
	 *
	 * @return		object
	 * @since		1.3.0
	 */
	public static function getInstance( $options = array() )
	{
		static $instance = null;
		
		if (! is_object( $instance ) ) {
				
			if ( defined( 'DUN_ENV' ) ) {
				$classname = ucfirst( strtolower( DUN_ENV ) ) . 'DunConfig';
				$instance	= new $classname( $options );
			}
			else {
				$instance = new self( $options );
			}
		}
	
		return $instance;
	}
	
	
	/**
	 * Method to determine if the config has a variable available
	 * @access		public
	 * @version		1.4.4 ( $id$ )
	 * @param		string		- $item: the variable item we are looking for
	 *
	 * @return		boolean
	 * @since		1.1.5
	 */
	public function has( $item )
	{
		return Configure :: exists( 'Dunamis.' . $item );
	} 
	
	
	/**
	 * Setter method
	 * @access		public
	 * @version		1.4.4
	 * @param		string		- $item: the setting being set
	 * @param		mixed		- $value: the value to set
	 * 
	 * @since		1.3.0
	 */
	public function set( $item, $value )
	{
		// Lets namespace to avoide conflicts
		Configure :: set ( 'Dunamis.' . $item, $value );
	}
}