<?php
use WHMCS\ClientArea;
use WHMCS\Database\Capsule;
use WGS\HOSTXVPSPAGE\VPS_PAGE_HOSTX as VPS_HOSTX;
define('CLIENTAREA', true);
require __DIR__ . '/init.php';
$ca = new ClientArea();
$ca->setPageTitle('Web Site Design');
$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('websitedesign.php', 'Web Site Design');
$ca->initPage();
$pageName = basename($_SERVER['PHP_SELF']);
$pageDataCount = Capsule::table("mod_hostx_pages")->where('pageTitle',$pageName)->count();
if($pageDataCount > 0){
	$pageDataFetched = Capsule::table("mod_hostx_pages")->where('pageTitle',$pageName)->first();
	$pageHaveProductsCount = Capsule::table('tblproducts')->where('gid',$pageDataFetched->productGroup)->where('hidden','!=', '1')->count();
	if($pageHaveProductsCount > 0){
		if(file_exists(__DIR__ . '/modules/addons/hostx/pages_data/hostx-vps-class.php')){
			require_once __DIR__ . '/modules/addons/hostx/pages_data/hostx-vps-class.php';
			$intializeVpsPageData = new VPS_HOSTX();
			$getProductInfoVpsPage = $intializeVpsPageData->wgsVpsPagesProductDataFetched($pageName);
			$ca->assign('pageHaveProductData','yes');
			$ca->assign('productsDataCycles', $getProductInfoVpsPage['prodcycles']);
			$ca->assign('productsData', $getProductInfoVpsPage['productInf']);
			$ca->assign('productsDataCount', $getProductInfoVpsPage['pageProductCount']);
		}
	}else{
		$ca->assign('pageHaveProductData','no');	
	}
}else{
	$ca->assign('pageHaveProductData','no');
}
$ca->assign('sidebarHostxRemove', 'true');
$ca->setTemplate('hostx');
$ca->output();